/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.codebuild.model.BuildArtifacts;
import software.amazon.awssdk.services.codebuild.model.BuildPhase;
import software.amazon.awssdk.services.codebuild.model.BuildPhasesCopier;
import software.amazon.awssdk.services.codebuild.model.LogsLocation;
import software.amazon.awssdk.services.codebuild.model.ProjectEnvironment;
import software.amazon.awssdk.services.codebuild.model.ProjectSource;
import software.amazon.awssdk.services.codebuild.model.StatusType;
import software.amazon.awssdk.services.codebuild.transform.BuildMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Build
implements StructuredPojo,
ToCopyableBuilder<Builder, Build> {
    private final String id;
    private final String arn;
    private final Instant startTime;
    private final Instant endTime;
    private final String currentPhase;
    private final String buildStatus;
    private final String sourceVersion;
    private final String projectName;
    private final List<BuildPhase> phases;
    private final ProjectSource source;
    private final BuildArtifacts artifacts;
    private final ProjectEnvironment environment;
    private final LogsLocation logs;
    private final Integer timeoutInMinutes;
    private final Boolean buildComplete;
    private final String initiator;

    private Build(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.currentPhase = builder.currentPhase;
        this.buildStatus = builder.buildStatus;
        this.sourceVersion = builder.sourceVersion;
        this.projectName = builder.projectName;
        this.phases = builder.phases;
        this.source = builder.source;
        this.artifacts = builder.artifacts;
        this.environment = builder.environment;
        this.logs = builder.logs;
        this.timeoutInMinutes = builder.timeoutInMinutes;
        this.buildComplete = builder.buildComplete;
        this.initiator = builder.initiator;
    }

    public String id() {
        return this.id;
    }

    public String arn() {
        return this.arn;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Instant endTime() {
        return this.endTime;
    }

    public String currentPhase() {
        return this.currentPhase;
    }

    public String buildStatus() {
        return this.buildStatus;
    }

    public String sourceVersion() {
        return this.sourceVersion;
    }

    public String projectName() {
        return this.projectName;
    }

    public List<BuildPhase> phases() {
        return this.phases;
    }

    public ProjectSource source() {
        return this.source;
    }

    public BuildArtifacts artifacts() {
        return this.artifacts;
    }

    public ProjectEnvironment environment() {
        return this.environment;
    }

    public LogsLocation logs() {
        return this.logs;
    }

    public Integer timeoutInMinutes() {
        return this.timeoutInMinutes;
    }

    public Boolean buildComplete() {
        return this.buildComplete;
    }

    public String initiator() {
        return this.initiator;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.id() == null ? 0 : this.id().hashCode());
        hashCode = 31 * hashCode + (this.arn() == null ? 0 : this.arn().hashCode());
        hashCode = 31 * hashCode + (this.startTime() == null ? 0 : this.startTime().hashCode());
        hashCode = 31 * hashCode + (this.endTime() == null ? 0 : this.endTime().hashCode());
        hashCode = 31 * hashCode + (this.currentPhase() == null ? 0 : this.currentPhase().hashCode());
        hashCode = 31 * hashCode + (this.buildStatus() == null ? 0 : this.buildStatus().hashCode());
        hashCode = 31 * hashCode + (this.sourceVersion() == null ? 0 : this.sourceVersion().hashCode());
        hashCode = 31 * hashCode + (this.projectName() == null ? 0 : this.projectName().hashCode());
        hashCode = 31 * hashCode + (this.phases() == null ? 0 : this.phases().hashCode());
        hashCode = 31 * hashCode + (this.source() == null ? 0 : this.source().hashCode());
        hashCode = 31 * hashCode + (this.artifacts() == null ? 0 : this.artifacts().hashCode());
        hashCode = 31 * hashCode + (this.environment() == null ? 0 : this.environment().hashCode());
        hashCode = 31 * hashCode + (this.logs() == null ? 0 : this.logs().hashCode());
        hashCode = 31 * hashCode + (this.timeoutInMinutes() == null ? 0 : this.timeoutInMinutes().hashCode());
        hashCode = 31 * hashCode + (this.buildComplete() == null ? 0 : this.buildComplete().hashCode());
        hashCode = 31 * hashCode + (this.initiator() == null ? 0 : this.initiator().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Build)) {
            return false;
        }
        Build other = (Build)obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.arn() == null ^ this.arn() == null) {
            return false;
        }
        if (other.arn() != null && !other.arn().equals(this.arn())) {
            return false;
        }
        if (other.startTime() == null ^ this.startTime() == null) {
            return false;
        }
        if (other.startTime() != null && !other.startTime().equals(this.startTime())) {
            return false;
        }
        if (other.endTime() == null ^ this.endTime() == null) {
            return false;
        }
        if (other.endTime() != null && !other.endTime().equals(this.endTime())) {
            return false;
        }
        if (other.currentPhase() == null ^ this.currentPhase() == null) {
            return false;
        }
        if (other.currentPhase() != null && !other.currentPhase().equals(this.currentPhase())) {
            return false;
        }
        if (other.buildStatus() == null ^ this.buildStatus() == null) {
            return false;
        }
        if (other.buildStatus() != null && !other.buildStatus().equals(this.buildStatus())) {
            return false;
        }
        if (other.sourceVersion() == null ^ this.sourceVersion() == null) {
            return false;
        }
        if (other.sourceVersion() != null && !other.sourceVersion().equals(this.sourceVersion())) {
            return false;
        }
        if (other.projectName() == null ^ this.projectName() == null) {
            return false;
        }
        if (other.projectName() != null && !other.projectName().equals(this.projectName())) {
            return false;
        }
        if (other.phases() == null ^ this.phases() == null) {
            return false;
        }
        if (other.phases() != null && !other.phases().equals(this.phases())) {
            return false;
        }
        if (other.source() == null ^ this.source() == null) {
            return false;
        }
        if (other.source() != null && !other.source().equals(this.source())) {
            return false;
        }
        if (other.artifacts() == null ^ this.artifacts() == null) {
            return false;
        }
        if (other.artifacts() != null && !other.artifacts().equals(this.artifacts())) {
            return false;
        }
        if (other.environment() == null ^ this.environment() == null) {
            return false;
        }
        if (other.environment() != null && !other.environment().equals(this.environment())) {
            return false;
        }
        if (other.logs() == null ^ this.logs() == null) {
            return false;
        }
        if (other.logs() != null && !other.logs().equals(this.logs())) {
            return false;
        }
        if (other.timeoutInMinutes() == null ^ this.timeoutInMinutes() == null) {
            return false;
        }
        if (other.timeoutInMinutes() != null && !other.timeoutInMinutes().equals(this.timeoutInMinutes())) {
            return false;
        }
        if (other.buildComplete() == null ^ this.buildComplete() == null) {
            return false;
        }
        if (other.buildComplete() != null && !other.buildComplete().equals(this.buildComplete())) {
            return false;
        }
        if (other.initiator() == null ^ this.initiator() == null) {
            return false;
        }
        return other.initiator() == null || other.initiator().equals(this.initiator());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.arn() != null) {
            sb.append("Arn: ").append(this.arn()).append(",");
        }
        if (this.startTime() != null) {
            sb.append("StartTime: ").append(this.startTime()).append(",");
        }
        if (this.endTime() != null) {
            sb.append("EndTime: ").append(this.endTime()).append(",");
        }
        if (this.currentPhase() != null) {
            sb.append("CurrentPhase: ").append(this.currentPhase()).append(",");
        }
        if (this.buildStatus() != null) {
            sb.append("BuildStatus: ").append(this.buildStatus()).append(",");
        }
        if (this.sourceVersion() != null) {
            sb.append("SourceVersion: ").append(this.sourceVersion()).append(",");
        }
        if (this.projectName() != null) {
            sb.append("ProjectName: ").append(this.projectName()).append(",");
        }
        if (this.phases() != null) {
            sb.append("Phases: ").append(this.phases()).append(",");
        }
        if (this.source() != null) {
            sb.append("Source: ").append(this.source()).append(",");
        }
        if (this.artifacts() != null) {
            sb.append("Artifacts: ").append(this.artifacts()).append(",");
        }
        if (this.environment() != null) {
            sb.append("Environment: ").append(this.environment()).append(",");
        }
        if (this.logs() != null) {
            sb.append("Logs: ").append(this.logs()).append(",");
        }
        if (this.timeoutInMinutes() != null) {
            sb.append("TimeoutInMinutes: ").append(this.timeoutInMinutes()).append(",");
        }
        if (this.buildComplete() != null) {
            sb.append("BuildComplete: ").append(this.buildComplete()).append(",");
        }
        if (this.initiator() != null) {
            sb.append("Initiator: ").append(this.initiator()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BuildMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private Instant startTime;
        private Instant endTime;
        private String currentPhase;
        private String buildStatus;
        private String sourceVersion;
        private String projectName;
        private List<BuildPhase> phases;
        private ProjectSource source;
        private BuildArtifacts artifacts;
        private ProjectEnvironment environment;
        private LogsLocation logs;
        private Integer timeoutInMinutes;
        private Boolean buildComplete;
        private String initiator;

        private BuilderImpl() {
        }

        private BuilderImpl(Build model) {
            this.setId(model.id);
            this.setArn(model.arn);
            this.setStartTime(model.startTime);
            this.setEndTime(model.endTime);
            this.setCurrentPhase(model.currentPhase);
            this.setBuildStatus(model.buildStatus);
            this.setSourceVersion(model.sourceVersion);
            this.setProjectName(model.projectName);
            this.setPhases(model.phases);
            this.setSource(model.source);
            this.setArtifacts(model.artifacts);
            this.setEnvironment(model.environment);
            this.setLogs(model.logs);
            this.setTimeoutInMinutes(model.timeoutInMinutes);
            this.setBuildComplete(model.buildComplete);
            this.setInitiator(model.initiator);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final String getCurrentPhase() {
            return this.currentPhase;
        }

        @Override
        public final Builder currentPhase(String currentPhase) {
            this.currentPhase = currentPhase;
            return this;
        }

        public final void setCurrentPhase(String currentPhase) {
            this.currentPhase = currentPhase;
        }

        public final String getBuildStatus() {
            return this.buildStatus;
        }

        @Override
        public final Builder buildStatus(String buildStatus) {
            this.buildStatus = buildStatus;
            return this;
        }

        @Override
        public final Builder buildStatus(StatusType buildStatus) {
            this.buildStatus(buildStatus.toString());
            return this;
        }

        public final void setBuildStatus(String buildStatus) {
            this.buildStatus = buildStatus;
        }

        public final void setBuildStatus(StatusType buildStatus) {
            this.buildStatus(buildStatus.toString());
        }

        public final String getSourceVersion() {
            return this.sourceVersion;
        }

        @Override
        public final Builder sourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
            return this;
        }

        public final void setSourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
        }

        public final String getProjectName() {
            return this.projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        public final Collection<BuildPhase> getPhases() {
            return this.phases;
        }

        @Override
        public final Builder phases(Collection<BuildPhase> phases) {
            this.phases = BuildPhasesCopier.copy(phases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phases(BuildPhase ... phases) {
            this.phases(Arrays.asList(phases));
            return this;
        }

        public final void setPhases(Collection<BuildPhase> phases) {
            this.phases = BuildPhasesCopier.copy(phases);
        }

        @SafeVarargs
        public final void setPhases(BuildPhase ... phases) {
            this.phases(Arrays.asList(phases));
        }

        public final ProjectSource getSource() {
            return this.source;
        }

        @Override
        public final Builder source(ProjectSource source) {
            this.source = source;
            return this;
        }

        public final void setSource(ProjectSource source) {
            this.source = source;
        }

        public final BuildArtifacts getArtifacts() {
            return this.artifacts;
        }

        @Override
        public final Builder artifacts(BuildArtifacts artifacts) {
            this.artifacts = artifacts;
            return this;
        }

        public final void setArtifacts(BuildArtifacts artifacts) {
            this.artifacts = artifacts;
        }

        public final ProjectEnvironment getEnvironment() {
            return this.environment;
        }

        @Override
        public final Builder environment(ProjectEnvironment environment) {
            this.environment = environment;
            return this;
        }

        public final void setEnvironment(ProjectEnvironment environment) {
            this.environment = environment;
        }

        public final LogsLocation getLogs() {
            return this.logs;
        }

        @Override
        public final Builder logs(LogsLocation logs) {
            this.logs = logs;
            return this;
        }

        public final void setLogs(LogsLocation logs) {
            this.logs = logs;
        }

        public final Integer getTimeoutInMinutes() {
            return this.timeoutInMinutes;
        }

        @Override
        public final Builder timeoutInMinutes(Integer timeoutInMinutes) {
            this.timeoutInMinutes = timeoutInMinutes;
            return this;
        }

        public final void setTimeoutInMinutes(Integer timeoutInMinutes) {
            this.timeoutInMinutes = timeoutInMinutes;
        }

        public final Boolean getBuildComplete() {
            return this.buildComplete;
        }

        @Override
        public final Builder buildComplete(Boolean buildComplete) {
            this.buildComplete = buildComplete;
            return this;
        }

        public final void setBuildComplete(Boolean buildComplete) {
            this.buildComplete = buildComplete;
        }

        public final String getInitiator() {
            return this.initiator;
        }

        @Override
        public final Builder initiator(String initiator) {
            this.initiator = initiator;
            return this;
        }

        public final void setInitiator(String initiator) {
            this.initiator = initiator;
        }

        public Build build() {
            return new Build(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Build> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder currentPhase(String var1);

        public Builder buildStatus(String var1);

        public Builder buildStatus(StatusType var1);

        public Builder sourceVersion(String var1);

        public Builder projectName(String var1);

        public Builder phases(Collection<BuildPhase> var1);

        public Builder phases(BuildPhase ... var1);

        public Builder source(ProjectSource var1);

        public Builder artifacts(BuildArtifacts var1);

        public Builder environment(ProjectEnvironment var1);

        public Builder logs(LogsLocation var1);

        public Builder timeoutInMinutes(Integer var1);

        public Builder buildComplete(Boolean var1);

        public Builder initiator(String var1);
    }
}

