/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.codebuild.model.CodeBuildRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateWebhookRequest
extends CodeBuildRequest
implements ToCopyableBuilder<Builder, UpdateWebhookRequest> {
    private final String projectName;
    private final String branchFilter;
    private final Boolean rotateSecret;

    private UpdateWebhookRequest(BuilderImpl builder) {
        super(builder);
        this.projectName = builder.projectName;
        this.branchFilter = builder.branchFilter;
        this.rotateSecret = builder.rotateSecret;
    }

    public String projectName() {
        return this.projectName;
    }

    public String branchFilter() {
        return this.branchFilter;
    }

    public Boolean rotateSecret() {
        return this.rotateSecret;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.projectName());
        hashCode = 31 * hashCode + Objects.hashCode(this.branchFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.rotateSecret());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWebhookRequest)) {
            return false;
        }
        UpdateWebhookRequest other = (UpdateWebhookRequest)((Object)obj);
        return Objects.equals(this.projectName(), other.projectName()) && Objects.equals(this.branchFilter(), other.branchFilter()) && Objects.equals(this.rotateSecret(), other.rotateSecret());
    }

    public String toString() {
        return ToString.builder((String)"UpdateWebhookRequest").add("ProjectName", (Object)this.projectName()).add("BranchFilter", (Object)this.branchFilter()).add("RotateSecret", (Object)this.rotateSecret()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "projectName": {
                return Optional.ofNullable(clazz.cast(this.projectName()));
            }
            case "branchFilter": {
                return Optional.ofNullable(clazz.cast(this.branchFilter()));
            }
            case "rotateSecret": {
                return Optional.ofNullable(clazz.cast(this.rotateSecret()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CodeBuildRequest.BuilderImpl
    implements Builder {
        private String projectName;
        private String branchFilter;
        private Boolean rotateSecret;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWebhookRequest model) {
            super(model);
            this.projectName(model.projectName);
            this.branchFilter(model.branchFilter);
            this.rotateSecret(model.rotateSecret);
        }

        public final String getProjectName() {
            return this.projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        public final String getBranchFilter() {
            return this.branchFilter;
        }

        @Override
        public final Builder branchFilter(String branchFilter) {
            this.branchFilter = branchFilter;
            return this;
        }

        public final void setBranchFilter(String branchFilter) {
            this.branchFilter = branchFilter;
        }

        public final Boolean getRotateSecret() {
            return this.rotateSecret;
        }

        @Override
        public final Builder rotateSecret(Boolean rotateSecret) {
            this.rotateSecret = rotateSecret;
            return this;
        }

        public final void setRotateSecret(Boolean rotateSecret) {
            this.rotateSecret = rotateSecret;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateWebhookRequest build() {
            return new UpdateWebhookRequest(this);
        }
    }

    public static interface Builder
    extends CodeBuildRequest.Builder,
    CopyableBuilder<Builder, UpdateWebhookRequest> {
        public Builder projectName(String var1);

        public Builder branchFilter(String var1);

        public Builder rotateSecret(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

