/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.codebuild.model.CodeBuildRequest;
import software.amazon.awssdk.services.codebuild.model.ComputeType;
import software.amazon.awssdk.services.codebuild.model.EnvironmentType;
import software.amazon.awssdk.services.codebuild.model.EnvironmentVariable;
import software.amazon.awssdk.services.codebuild.model.EnvironmentVariablesCopier;
import software.amazon.awssdk.services.codebuild.model.ProjectArtifacts;
import software.amazon.awssdk.services.codebuild.model.ProjectArtifactsListCopier;
import software.amazon.awssdk.services.codebuild.model.ProjectCache;
import software.amazon.awssdk.services.codebuild.model.ProjectSecondarySourceVersionsCopier;
import software.amazon.awssdk.services.codebuild.model.ProjectSource;
import software.amazon.awssdk.services.codebuild.model.ProjectSourceVersion;
import software.amazon.awssdk.services.codebuild.model.ProjectSourcesCopier;
import software.amazon.awssdk.services.codebuild.model.SourceAuth;
import software.amazon.awssdk.services.codebuild.model.SourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartBuildRequest
extends CodeBuildRequest
implements ToCopyableBuilder<Builder, StartBuildRequest> {
    private final String projectName;
    private final List<ProjectSource> secondarySourcesOverride;
    private final List<ProjectSourceVersion> secondarySourcesVersionOverride;
    private final String sourceVersion;
    private final ProjectArtifacts artifactsOverride;
    private final List<ProjectArtifacts> secondaryArtifactsOverride;
    private final List<EnvironmentVariable> environmentVariablesOverride;
    private final String sourceTypeOverride;
    private final String sourceLocationOverride;
    private final SourceAuth sourceAuthOverride;
    private final Integer gitCloneDepthOverride;
    private final String buildspecOverride;
    private final Boolean insecureSslOverride;
    private final Boolean reportBuildStatusOverride;
    private final String environmentTypeOverride;
    private final String imageOverride;
    private final String computeTypeOverride;
    private final String certificateOverride;
    private final ProjectCache cacheOverride;
    private final String serviceRoleOverride;
    private final Boolean privilegedModeOverride;
    private final Integer timeoutInMinutesOverride;
    private final String idempotencyToken;

    private StartBuildRequest(BuilderImpl builder) {
        super(builder);
        this.projectName = builder.projectName;
        this.secondarySourcesOverride = builder.secondarySourcesOverride;
        this.secondarySourcesVersionOverride = builder.secondarySourcesVersionOverride;
        this.sourceVersion = builder.sourceVersion;
        this.artifactsOverride = builder.artifactsOverride;
        this.secondaryArtifactsOverride = builder.secondaryArtifactsOverride;
        this.environmentVariablesOverride = builder.environmentVariablesOverride;
        this.sourceTypeOverride = builder.sourceTypeOverride;
        this.sourceLocationOverride = builder.sourceLocationOverride;
        this.sourceAuthOverride = builder.sourceAuthOverride;
        this.gitCloneDepthOverride = builder.gitCloneDepthOverride;
        this.buildspecOverride = builder.buildspecOverride;
        this.insecureSslOverride = builder.insecureSslOverride;
        this.reportBuildStatusOverride = builder.reportBuildStatusOverride;
        this.environmentTypeOverride = builder.environmentTypeOverride;
        this.imageOverride = builder.imageOverride;
        this.computeTypeOverride = builder.computeTypeOverride;
        this.certificateOverride = builder.certificateOverride;
        this.cacheOverride = builder.cacheOverride;
        this.serviceRoleOverride = builder.serviceRoleOverride;
        this.privilegedModeOverride = builder.privilegedModeOverride;
        this.timeoutInMinutesOverride = builder.timeoutInMinutesOverride;
        this.idempotencyToken = builder.idempotencyToken;
    }

    public String projectName() {
        return this.projectName;
    }

    public List<ProjectSource> secondarySourcesOverride() {
        return this.secondarySourcesOverride;
    }

    public List<ProjectSourceVersion> secondarySourcesVersionOverride() {
        return this.secondarySourcesVersionOverride;
    }

    public String sourceVersion() {
        return this.sourceVersion;
    }

    public ProjectArtifacts artifactsOverride() {
        return this.artifactsOverride;
    }

    public List<ProjectArtifacts> secondaryArtifactsOverride() {
        return this.secondaryArtifactsOverride;
    }

    public List<EnvironmentVariable> environmentVariablesOverride() {
        return this.environmentVariablesOverride;
    }

    public SourceType sourceTypeOverride() {
        return SourceType.fromValue(this.sourceTypeOverride);
    }

    public String sourceTypeOverrideAsString() {
        return this.sourceTypeOverride;
    }

    public String sourceLocationOverride() {
        return this.sourceLocationOverride;
    }

    public SourceAuth sourceAuthOverride() {
        return this.sourceAuthOverride;
    }

    public Integer gitCloneDepthOverride() {
        return this.gitCloneDepthOverride;
    }

    public String buildspecOverride() {
        return this.buildspecOverride;
    }

    public Boolean insecureSslOverride() {
        return this.insecureSslOverride;
    }

    public Boolean reportBuildStatusOverride() {
        return this.reportBuildStatusOverride;
    }

    public EnvironmentType environmentTypeOverride() {
        return EnvironmentType.fromValue(this.environmentTypeOverride);
    }

    public String environmentTypeOverrideAsString() {
        return this.environmentTypeOverride;
    }

    public String imageOverride() {
        return this.imageOverride;
    }

    public ComputeType computeTypeOverride() {
        return ComputeType.fromValue(this.computeTypeOverride);
    }

    public String computeTypeOverrideAsString() {
        return this.computeTypeOverride;
    }

    public String certificateOverride() {
        return this.certificateOverride;
    }

    public ProjectCache cacheOverride() {
        return this.cacheOverride;
    }

    public String serviceRoleOverride() {
        return this.serviceRoleOverride;
    }

    public Boolean privilegedModeOverride() {
        return this.privilegedModeOverride;
    }

    public Integer timeoutInMinutesOverride() {
        return this.timeoutInMinutesOverride;
    }

    public String idempotencyToken() {
        return this.idempotencyToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.projectName());
        hashCode = 31 * hashCode + Objects.hashCode(this.secondarySourcesOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.secondarySourcesVersionOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.artifactsOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.secondaryArtifactsOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentVariablesOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceTypeOverrideAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceLocationOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceAuthOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.gitCloneDepthOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.buildspecOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.insecureSslOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.reportBuildStatusOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentTypeOverrideAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeTypeOverrideAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceRoleOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.privilegedModeOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutInMinutesOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.idempotencyToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartBuildRequest)) {
            return false;
        }
        StartBuildRequest other = (StartBuildRequest)((Object)obj);
        return Objects.equals(this.projectName(), other.projectName()) && Objects.equals(this.secondarySourcesOverride(), other.secondarySourcesOverride()) && Objects.equals(this.secondarySourcesVersionOverride(), other.secondarySourcesVersionOverride()) && Objects.equals(this.sourceVersion(), other.sourceVersion()) && Objects.equals(this.artifactsOverride(), other.artifactsOverride()) && Objects.equals(this.secondaryArtifactsOverride(), other.secondaryArtifactsOverride()) && Objects.equals(this.environmentVariablesOverride(), other.environmentVariablesOverride()) && Objects.equals(this.sourceTypeOverrideAsString(), other.sourceTypeOverrideAsString()) && Objects.equals(this.sourceLocationOverride(), other.sourceLocationOverride()) && Objects.equals(this.sourceAuthOverride(), other.sourceAuthOverride()) && Objects.equals(this.gitCloneDepthOverride(), other.gitCloneDepthOverride()) && Objects.equals(this.buildspecOverride(), other.buildspecOverride()) && Objects.equals(this.insecureSslOverride(), other.insecureSslOverride()) && Objects.equals(this.reportBuildStatusOverride(), other.reportBuildStatusOverride()) && Objects.equals(this.environmentTypeOverrideAsString(), other.environmentTypeOverrideAsString()) && Objects.equals(this.imageOverride(), other.imageOverride()) && Objects.equals(this.computeTypeOverrideAsString(), other.computeTypeOverrideAsString()) && Objects.equals(this.certificateOverride(), other.certificateOverride()) && Objects.equals(this.cacheOverride(), other.cacheOverride()) && Objects.equals(this.serviceRoleOverride(), other.serviceRoleOverride()) && Objects.equals(this.privilegedModeOverride(), other.privilegedModeOverride()) && Objects.equals(this.timeoutInMinutesOverride(), other.timeoutInMinutesOverride()) && Objects.equals(this.idempotencyToken(), other.idempotencyToken());
    }

    public String toString() {
        return ToString.builder((String)"StartBuildRequest").add("ProjectName", (Object)this.projectName()).add("SecondarySourcesOverride", this.secondarySourcesOverride()).add("SecondarySourcesVersionOverride", this.secondarySourcesVersionOverride()).add("SourceVersion", (Object)this.sourceVersion()).add("ArtifactsOverride", (Object)this.artifactsOverride()).add("SecondaryArtifactsOverride", this.secondaryArtifactsOverride()).add("EnvironmentVariablesOverride", this.environmentVariablesOverride()).add("SourceTypeOverride", (Object)this.sourceTypeOverrideAsString()).add("SourceLocationOverride", (Object)this.sourceLocationOverride()).add("SourceAuthOverride", (Object)this.sourceAuthOverride()).add("GitCloneDepthOverride", (Object)this.gitCloneDepthOverride()).add("BuildspecOverride", (Object)this.buildspecOverride()).add("InsecureSslOverride", (Object)this.insecureSslOverride()).add("ReportBuildStatusOverride", (Object)this.reportBuildStatusOverride()).add("EnvironmentTypeOverride", (Object)this.environmentTypeOverrideAsString()).add("ImageOverride", (Object)this.imageOverride()).add("ComputeTypeOverride", (Object)this.computeTypeOverrideAsString()).add("CertificateOverride", (Object)this.certificateOverride()).add("CacheOverride", (Object)this.cacheOverride()).add("ServiceRoleOverride", (Object)this.serviceRoleOverride()).add("PrivilegedModeOverride", (Object)this.privilegedModeOverride()).add("TimeoutInMinutesOverride", (Object)this.timeoutInMinutesOverride()).add("IdempotencyToken", (Object)this.idempotencyToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "projectName": {
                return Optional.ofNullable(clazz.cast(this.projectName()));
            }
            case "secondarySourcesOverride": {
                return Optional.ofNullable(clazz.cast(this.secondarySourcesOverride()));
            }
            case "secondarySourcesVersionOverride": {
                return Optional.ofNullable(clazz.cast(this.secondarySourcesVersionOverride()));
            }
            case "sourceVersion": {
                return Optional.ofNullable(clazz.cast(this.sourceVersion()));
            }
            case "artifactsOverride": {
                return Optional.ofNullable(clazz.cast(this.artifactsOverride()));
            }
            case "secondaryArtifactsOverride": {
                return Optional.ofNullable(clazz.cast(this.secondaryArtifactsOverride()));
            }
            case "environmentVariablesOverride": {
                return Optional.ofNullable(clazz.cast(this.environmentVariablesOverride()));
            }
            case "sourceTypeOverride": {
                return Optional.ofNullable(clazz.cast(this.sourceTypeOverrideAsString()));
            }
            case "sourceLocationOverride": {
                return Optional.ofNullable(clazz.cast(this.sourceLocationOverride()));
            }
            case "sourceAuthOverride": {
                return Optional.ofNullable(clazz.cast(this.sourceAuthOverride()));
            }
            case "gitCloneDepthOverride": {
                return Optional.ofNullable(clazz.cast(this.gitCloneDepthOverride()));
            }
            case "buildspecOverride": {
                return Optional.ofNullable(clazz.cast(this.buildspecOverride()));
            }
            case "insecureSslOverride": {
                return Optional.ofNullable(clazz.cast(this.insecureSslOverride()));
            }
            case "reportBuildStatusOverride": {
                return Optional.ofNullable(clazz.cast(this.reportBuildStatusOverride()));
            }
            case "environmentTypeOverride": {
                return Optional.ofNullable(clazz.cast(this.environmentTypeOverrideAsString()));
            }
            case "imageOverride": {
                return Optional.ofNullable(clazz.cast(this.imageOverride()));
            }
            case "computeTypeOverride": {
                return Optional.ofNullable(clazz.cast(this.computeTypeOverrideAsString()));
            }
            case "certificateOverride": {
                return Optional.ofNullable(clazz.cast(this.certificateOverride()));
            }
            case "cacheOverride": {
                return Optional.ofNullable(clazz.cast(this.cacheOverride()));
            }
            case "serviceRoleOverride": {
                return Optional.ofNullable(clazz.cast(this.serviceRoleOverride()));
            }
            case "privilegedModeOverride": {
                return Optional.ofNullable(clazz.cast(this.privilegedModeOverride()));
            }
            case "timeoutInMinutesOverride": {
                return Optional.ofNullable(clazz.cast(this.timeoutInMinutesOverride()));
            }
            case "idempotencyToken": {
                return Optional.ofNullable(clazz.cast(this.idempotencyToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CodeBuildRequest.BuilderImpl
    implements Builder {
        private String projectName;
        private List<ProjectSource> secondarySourcesOverride = DefaultSdkAutoConstructList.getInstance();
        private List<ProjectSourceVersion> secondarySourcesVersionOverride = DefaultSdkAutoConstructList.getInstance();
        private String sourceVersion;
        private ProjectArtifacts artifactsOverride;
        private List<ProjectArtifacts> secondaryArtifactsOverride = DefaultSdkAutoConstructList.getInstance();
        private List<EnvironmentVariable> environmentVariablesOverride = DefaultSdkAutoConstructList.getInstance();
        private String sourceTypeOverride;
        private String sourceLocationOverride;
        private SourceAuth sourceAuthOverride;
        private Integer gitCloneDepthOverride;
        private String buildspecOverride;
        private Boolean insecureSslOverride;
        private Boolean reportBuildStatusOverride;
        private String environmentTypeOverride;
        private String imageOverride;
        private String computeTypeOverride;
        private String certificateOverride;
        private ProjectCache cacheOverride;
        private String serviceRoleOverride;
        private Boolean privilegedModeOverride;
        private Integer timeoutInMinutesOverride;
        private String idempotencyToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StartBuildRequest model) {
            super(model);
            this.projectName(model.projectName);
            this.secondarySourcesOverride(model.secondarySourcesOverride);
            this.secondarySourcesVersionOverride(model.secondarySourcesVersionOverride);
            this.sourceVersion(model.sourceVersion);
            this.artifactsOverride(model.artifactsOverride);
            this.secondaryArtifactsOverride(model.secondaryArtifactsOverride);
            this.environmentVariablesOverride(model.environmentVariablesOverride);
            this.sourceTypeOverride(model.sourceTypeOverride);
            this.sourceLocationOverride(model.sourceLocationOverride);
            this.sourceAuthOverride(model.sourceAuthOverride);
            this.gitCloneDepthOverride(model.gitCloneDepthOverride);
            this.buildspecOverride(model.buildspecOverride);
            this.insecureSslOverride(model.insecureSslOverride);
            this.reportBuildStatusOverride(model.reportBuildStatusOverride);
            this.environmentTypeOverride(model.environmentTypeOverride);
            this.imageOverride(model.imageOverride);
            this.computeTypeOverride(model.computeTypeOverride);
            this.certificateOverride(model.certificateOverride);
            this.cacheOverride(model.cacheOverride);
            this.serviceRoleOverride(model.serviceRoleOverride);
            this.privilegedModeOverride(model.privilegedModeOverride);
            this.timeoutInMinutesOverride(model.timeoutInMinutesOverride);
            this.idempotencyToken(model.idempotencyToken);
        }

        public final String getProjectName() {
            return this.projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        public final Collection<ProjectSource.Builder> getSecondarySourcesOverride() {
            return this.secondarySourcesOverride != null ? (Collection)this.secondarySourcesOverride.stream().map(ProjectSource::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder secondarySourcesOverride(Collection<ProjectSource> secondarySourcesOverride) {
            this.secondarySourcesOverride = ProjectSourcesCopier.copy(secondarySourcesOverride);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondarySourcesOverride(ProjectSource ... secondarySourcesOverride) {
            this.secondarySourcesOverride(Arrays.asList(secondarySourcesOverride));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondarySourcesOverride(Consumer<ProjectSource.Builder> ... secondarySourcesOverride) {
            this.secondarySourcesOverride(Stream.of(secondarySourcesOverride).map(c -> (ProjectSource)((ProjectSource.Builder)ProjectSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSecondarySourcesOverride(Collection<ProjectSource.BuilderImpl> secondarySourcesOverride) {
            this.secondarySourcesOverride = ProjectSourcesCopier.copyFromBuilder(secondarySourcesOverride);
        }

        public final Collection<ProjectSourceVersion.Builder> getSecondarySourcesVersionOverride() {
            return this.secondarySourcesVersionOverride != null ? (Collection)this.secondarySourcesVersionOverride.stream().map(ProjectSourceVersion::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder secondarySourcesVersionOverride(Collection<ProjectSourceVersion> secondarySourcesVersionOverride) {
            this.secondarySourcesVersionOverride = ProjectSecondarySourceVersionsCopier.copy(secondarySourcesVersionOverride);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondarySourcesVersionOverride(ProjectSourceVersion ... secondarySourcesVersionOverride) {
            this.secondarySourcesVersionOverride(Arrays.asList(secondarySourcesVersionOverride));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondarySourcesVersionOverride(Consumer<ProjectSourceVersion.Builder> ... secondarySourcesVersionOverride) {
            this.secondarySourcesVersionOverride(Stream.of(secondarySourcesVersionOverride).map(c -> (ProjectSourceVersion)((ProjectSourceVersion.Builder)ProjectSourceVersion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSecondarySourcesVersionOverride(Collection<ProjectSourceVersion.BuilderImpl> secondarySourcesVersionOverride) {
            this.secondarySourcesVersionOverride = ProjectSecondarySourceVersionsCopier.copyFromBuilder(secondarySourcesVersionOverride);
        }

        public final String getSourceVersion() {
            return this.sourceVersion;
        }

        @Override
        public final Builder sourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
            return this;
        }

        public final void setSourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
        }

        public final ProjectArtifacts.Builder getArtifactsOverride() {
            return this.artifactsOverride != null ? this.artifactsOverride.toBuilder() : null;
        }

        @Override
        public final Builder artifactsOverride(ProjectArtifacts artifactsOverride) {
            this.artifactsOverride = artifactsOverride;
            return this;
        }

        public final void setArtifactsOverride(ProjectArtifacts.BuilderImpl artifactsOverride) {
            this.artifactsOverride = artifactsOverride != null ? artifactsOverride.build() : null;
        }

        public final Collection<ProjectArtifacts.Builder> getSecondaryArtifactsOverride() {
            return this.secondaryArtifactsOverride != null ? (Collection)this.secondaryArtifactsOverride.stream().map(ProjectArtifacts::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder secondaryArtifactsOverride(Collection<ProjectArtifacts> secondaryArtifactsOverride) {
            this.secondaryArtifactsOverride = ProjectArtifactsListCopier.copy(secondaryArtifactsOverride);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondaryArtifactsOverride(ProjectArtifacts ... secondaryArtifactsOverride) {
            this.secondaryArtifactsOverride(Arrays.asList(secondaryArtifactsOverride));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondaryArtifactsOverride(Consumer<ProjectArtifacts.Builder> ... secondaryArtifactsOverride) {
            this.secondaryArtifactsOverride(Stream.of(secondaryArtifactsOverride).map(c -> (ProjectArtifacts)((ProjectArtifacts.Builder)ProjectArtifacts.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSecondaryArtifactsOverride(Collection<ProjectArtifacts.BuilderImpl> secondaryArtifactsOverride) {
            this.secondaryArtifactsOverride = ProjectArtifactsListCopier.copyFromBuilder(secondaryArtifactsOverride);
        }

        public final Collection<EnvironmentVariable.Builder> getEnvironmentVariablesOverride() {
            return this.environmentVariablesOverride != null ? (Collection)this.environmentVariablesOverride.stream().map(EnvironmentVariable::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder environmentVariablesOverride(Collection<EnvironmentVariable> environmentVariablesOverride) {
            this.environmentVariablesOverride = EnvironmentVariablesCopier.copy(environmentVariablesOverride);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentVariablesOverride(EnvironmentVariable ... environmentVariablesOverride) {
            this.environmentVariablesOverride(Arrays.asList(environmentVariablesOverride));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentVariablesOverride(Consumer<EnvironmentVariable.Builder> ... environmentVariablesOverride) {
            this.environmentVariablesOverride(Stream.of(environmentVariablesOverride).map(c -> (EnvironmentVariable)((EnvironmentVariable.Builder)EnvironmentVariable.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEnvironmentVariablesOverride(Collection<EnvironmentVariable.BuilderImpl> environmentVariablesOverride) {
            this.environmentVariablesOverride = EnvironmentVariablesCopier.copyFromBuilder(environmentVariablesOverride);
        }

        public final String getSourceTypeOverride() {
            return this.sourceTypeOverride;
        }

        @Override
        public final Builder sourceTypeOverride(String sourceTypeOverride) {
            this.sourceTypeOverride = sourceTypeOverride;
            return this;
        }

        @Override
        public final Builder sourceTypeOverride(SourceType sourceTypeOverride) {
            this.sourceTypeOverride(sourceTypeOverride.toString());
            return this;
        }

        public final void setSourceTypeOverride(String sourceTypeOverride) {
            this.sourceTypeOverride = sourceTypeOverride;
        }

        public final String getSourceLocationOverride() {
            return this.sourceLocationOverride;
        }

        @Override
        public final Builder sourceLocationOverride(String sourceLocationOverride) {
            this.sourceLocationOverride = sourceLocationOverride;
            return this;
        }

        public final void setSourceLocationOverride(String sourceLocationOverride) {
            this.sourceLocationOverride = sourceLocationOverride;
        }

        public final SourceAuth.Builder getSourceAuthOverride() {
            return this.sourceAuthOverride != null ? this.sourceAuthOverride.toBuilder() : null;
        }

        @Override
        public final Builder sourceAuthOverride(SourceAuth sourceAuthOverride) {
            this.sourceAuthOverride = sourceAuthOverride;
            return this;
        }

        public final void setSourceAuthOverride(SourceAuth.BuilderImpl sourceAuthOverride) {
            this.sourceAuthOverride = sourceAuthOverride != null ? sourceAuthOverride.build() : null;
        }

        public final Integer getGitCloneDepthOverride() {
            return this.gitCloneDepthOverride;
        }

        @Override
        public final Builder gitCloneDepthOverride(Integer gitCloneDepthOverride) {
            this.gitCloneDepthOverride = gitCloneDepthOverride;
            return this;
        }

        public final void setGitCloneDepthOverride(Integer gitCloneDepthOverride) {
            this.gitCloneDepthOverride = gitCloneDepthOverride;
        }

        public final String getBuildspecOverride() {
            return this.buildspecOverride;
        }

        @Override
        public final Builder buildspecOverride(String buildspecOverride) {
            this.buildspecOverride = buildspecOverride;
            return this;
        }

        public final void setBuildspecOverride(String buildspecOverride) {
            this.buildspecOverride = buildspecOverride;
        }

        public final Boolean getInsecureSslOverride() {
            return this.insecureSslOverride;
        }

        @Override
        public final Builder insecureSslOverride(Boolean insecureSslOverride) {
            this.insecureSslOverride = insecureSslOverride;
            return this;
        }

        public final void setInsecureSslOverride(Boolean insecureSslOverride) {
            this.insecureSslOverride = insecureSslOverride;
        }

        public final Boolean getReportBuildStatusOverride() {
            return this.reportBuildStatusOverride;
        }

        @Override
        public final Builder reportBuildStatusOverride(Boolean reportBuildStatusOverride) {
            this.reportBuildStatusOverride = reportBuildStatusOverride;
            return this;
        }

        public final void setReportBuildStatusOverride(Boolean reportBuildStatusOverride) {
            this.reportBuildStatusOverride = reportBuildStatusOverride;
        }

        public final String getEnvironmentTypeOverride() {
            return this.environmentTypeOverride;
        }

        @Override
        public final Builder environmentTypeOverride(String environmentTypeOverride) {
            this.environmentTypeOverride = environmentTypeOverride;
            return this;
        }

        @Override
        public final Builder environmentTypeOverride(EnvironmentType environmentTypeOverride) {
            this.environmentTypeOverride(environmentTypeOverride.toString());
            return this;
        }

        public final void setEnvironmentTypeOverride(String environmentTypeOverride) {
            this.environmentTypeOverride = environmentTypeOverride;
        }

        public final String getImageOverride() {
            return this.imageOverride;
        }

        @Override
        public final Builder imageOverride(String imageOverride) {
            this.imageOverride = imageOverride;
            return this;
        }

        public final void setImageOverride(String imageOverride) {
            this.imageOverride = imageOverride;
        }

        public final String getComputeTypeOverride() {
            return this.computeTypeOverride;
        }

        @Override
        public final Builder computeTypeOverride(String computeTypeOverride) {
            this.computeTypeOverride = computeTypeOverride;
            return this;
        }

        @Override
        public final Builder computeTypeOverride(ComputeType computeTypeOverride) {
            this.computeTypeOverride(computeTypeOverride.toString());
            return this;
        }

        public final void setComputeTypeOverride(String computeTypeOverride) {
            this.computeTypeOverride = computeTypeOverride;
        }

        public final String getCertificateOverride() {
            return this.certificateOverride;
        }

        @Override
        public final Builder certificateOverride(String certificateOverride) {
            this.certificateOverride = certificateOverride;
            return this;
        }

        public final void setCertificateOverride(String certificateOverride) {
            this.certificateOverride = certificateOverride;
        }

        public final ProjectCache.Builder getCacheOverride() {
            return this.cacheOverride != null ? this.cacheOverride.toBuilder() : null;
        }

        @Override
        public final Builder cacheOverride(ProjectCache cacheOverride) {
            this.cacheOverride = cacheOverride;
            return this;
        }

        public final void setCacheOverride(ProjectCache.BuilderImpl cacheOverride) {
            this.cacheOverride = cacheOverride != null ? cacheOverride.build() : null;
        }

        public final String getServiceRoleOverride() {
            return this.serviceRoleOverride;
        }

        @Override
        public final Builder serviceRoleOverride(String serviceRoleOverride) {
            this.serviceRoleOverride = serviceRoleOverride;
            return this;
        }

        public final void setServiceRoleOverride(String serviceRoleOverride) {
            this.serviceRoleOverride = serviceRoleOverride;
        }

        public final Boolean getPrivilegedModeOverride() {
            return this.privilegedModeOverride;
        }

        @Override
        public final Builder privilegedModeOverride(Boolean privilegedModeOverride) {
            this.privilegedModeOverride = privilegedModeOverride;
            return this;
        }

        public final void setPrivilegedModeOverride(Boolean privilegedModeOverride) {
            this.privilegedModeOverride = privilegedModeOverride;
        }

        public final Integer getTimeoutInMinutesOverride() {
            return this.timeoutInMinutesOverride;
        }

        @Override
        public final Builder timeoutInMinutesOverride(Integer timeoutInMinutesOverride) {
            this.timeoutInMinutesOverride = timeoutInMinutesOverride;
            return this;
        }

        public final void setTimeoutInMinutesOverride(Integer timeoutInMinutesOverride) {
            this.timeoutInMinutesOverride = timeoutInMinutesOverride;
        }

        public final String getIdempotencyToken() {
            return this.idempotencyToken;
        }

        @Override
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartBuildRequest build() {
            return new StartBuildRequest(this);
        }
    }

    public static interface Builder
    extends CodeBuildRequest.Builder,
    CopyableBuilder<Builder, StartBuildRequest> {
        public Builder projectName(String var1);

        public Builder secondarySourcesOverride(Collection<ProjectSource> var1);

        public Builder secondarySourcesOverride(ProjectSource ... var1);

        public Builder secondarySourcesOverride(Consumer<ProjectSource.Builder> ... var1);

        public Builder secondarySourcesVersionOverride(Collection<ProjectSourceVersion> var1);

        public Builder secondarySourcesVersionOverride(ProjectSourceVersion ... var1);

        public Builder secondarySourcesVersionOverride(Consumer<ProjectSourceVersion.Builder> ... var1);

        public Builder sourceVersion(String var1);

        public Builder artifactsOverride(ProjectArtifacts var1);

        default public Builder artifactsOverride(Consumer<ProjectArtifacts.Builder> artifactsOverride) {
            return this.artifactsOverride((ProjectArtifacts)((ProjectArtifacts.Builder)ProjectArtifacts.builder().applyMutation(artifactsOverride)).build());
        }

        public Builder secondaryArtifactsOverride(Collection<ProjectArtifacts> var1);

        public Builder secondaryArtifactsOverride(ProjectArtifacts ... var1);

        public Builder secondaryArtifactsOverride(Consumer<ProjectArtifacts.Builder> ... var1);

        public Builder environmentVariablesOverride(Collection<EnvironmentVariable> var1);

        public Builder environmentVariablesOverride(EnvironmentVariable ... var1);

        public Builder environmentVariablesOverride(Consumer<EnvironmentVariable.Builder> ... var1);

        public Builder sourceTypeOverride(String var1);

        public Builder sourceTypeOverride(SourceType var1);

        public Builder sourceLocationOverride(String var1);

        public Builder sourceAuthOverride(SourceAuth var1);

        default public Builder sourceAuthOverride(Consumer<SourceAuth.Builder> sourceAuthOverride) {
            return this.sourceAuthOverride((SourceAuth)((SourceAuth.Builder)SourceAuth.builder().applyMutation(sourceAuthOverride)).build());
        }

        public Builder gitCloneDepthOverride(Integer var1);

        public Builder buildspecOverride(String var1);

        public Builder insecureSslOverride(Boolean var1);

        public Builder reportBuildStatusOverride(Boolean var1);

        public Builder environmentTypeOverride(String var1);

        public Builder environmentTypeOverride(EnvironmentType var1);

        public Builder imageOverride(String var1);

        public Builder computeTypeOverride(String var1);

        public Builder computeTypeOverride(ComputeType var1);

        public Builder certificateOverride(String var1);

        public Builder cacheOverride(ProjectCache var1);

        default public Builder cacheOverride(Consumer<ProjectCache.Builder> cacheOverride) {
            return this.cacheOverride((ProjectCache)((ProjectCache.Builder)ProjectCache.builder().applyMutation(cacheOverride)).build());
        }

        public Builder serviceRoleOverride(String var1);

        public Builder privilegedModeOverride(Boolean var1);

        public Builder timeoutInMinutesOverride(Integer var1);

        public Builder idempotencyToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

