/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codebuild.transform.ProjectBadgeMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProjectBadge
implements StructuredPojo,
ToCopyableBuilder<Builder, ProjectBadge> {
    private final Boolean badgeEnabled;
    private final String badgeRequestUrl;

    private ProjectBadge(BuilderImpl builder) {
        this.badgeEnabled = builder.badgeEnabled;
        this.badgeRequestUrl = builder.badgeRequestUrl;
    }

    public Boolean badgeEnabled() {
        return this.badgeEnabled;
    }

    public String badgeRequestUrl() {
        return this.badgeRequestUrl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.badgeEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.badgeRequestUrl());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProjectBadge)) {
            return false;
        }
        ProjectBadge other = (ProjectBadge)obj;
        return Objects.equals(this.badgeEnabled(), other.badgeEnabled()) && Objects.equals(this.badgeRequestUrl(), other.badgeRequestUrl());
    }

    public String toString() {
        return ToString.builder((String)"ProjectBadge").add("BadgeEnabled", (Object)this.badgeEnabled()).add("BadgeRequestUrl", (Object)this.badgeRequestUrl()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "badgeEnabled": {
                return Optional.ofNullable(clazz.cast(this.badgeEnabled()));
            }
            case "badgeRequestUrl": {
                return Optional.ofNullable(clazz.cast(this.badgeRequestUrl()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProjectBadgeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean badgeEnabled;
        private String badgeRequestUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(ProjectBadge model) {
            this.badgeEnabled(model.badgeEnabled);
            this.badgeRequestUrl(model.badgeRequestUrl);
        }

        public final Boolean getBadgeEnabled() {
            return this.badgeEnabled;
        }

        @Override
        public final Builder badgeEnabled(Boolean badgeEnabled) {
            this.badgeEnabled = badgeEnabled;
            return this;
        }

        public final void setBadgeEnabled(Boolean badgeEnabled) {
            this.badgeEnabled = badgeEnabled;
        }

        public final String getBadgeRequestUrl() {
            return this.badgeRequestUrl;
        }

        @Override
        public final Builder badgeRequestUrl(String badgeRequestUrl) {
            this.badgeRequestUrl = badgeRequestUrl;
            return this;
        }

        public final void setBadgeRequestUrl(String badgeRequestUrl) {
            this.badgeRequestUrl = badgeRequestUrl;
        }

        public ProjectBadge build() {
            return new ProjectBadge(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ProjectBadge> {
        public Builder badgeEnabled(Boolean var1);

        public Builder badgeRequestUrl(String var1);
    }
}

