/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codebuild.model.LogsLocation;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class LogsLocationMarshaller {
    private static final MarshallingInfo<String> GROUPNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("groupName").isBinary(false).build();
    private static final MarshallingInfo<String> STREAMNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("streamName").isBinary(false).build();
    private static final MarshallingInfo<String> DEEPLINK_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("deepLink").isBinary(false).build();
    private static final LogsLocationMarshaller INSTANCE = new LogsLocationMarshaller();

    private LogsLocationMarshaller() {
    }

    public static LogsLocationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(LogsLocation logsLocation, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)logsLocation, (String)"logsLocation");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)logsLocation.groupName(), GROUPNAME_BINDING);
            protocolMarshaller.marshall((Object)logsLocation.streamName(), STREAMNAME_BINDING);
            protocolMarshaller.marshall((Object)logsLocation.deepLink(), DEEPLINK_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

