/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codebuild.model.ComputeType;
import software.amazon.awssdk.services.codebuild.model.EnvironmentType;
import software.amazon.awssdk.services.codebuild.model.EnvironmentVariable;
import software.amazon.awssdk.services.codebuild.model.EnvironmentVariablesCopier;
import software.amazon.awssdk.services.codebuild.transform.ProjectEnvironmentMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ProjectEnvironment
implements StructuredPojo,
ToCopyableBuilder<Builder, ProjectEnvironment> {
    private final String type;
    private final String image;
    private final String computeType;
    private final List<EnvironmentVariable> environmentVariables;
    private final Boolean privilegedMode;

    private ProjectEnvironment(BuilderImpl builder) {
        this.type = builder.type;
        this.image = builder.image;
        this.computeType = builder.computeType;
        this.environmentVariables = builder.environmentVariables;
        this.privilegedMode = builder.privilegedMode;
    }

    public EnvironmentType type() {
        return EnvironmentType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public String image() {
        return this.image;
    }

    public ComputeType computeType() {
        return ComputeType.fromValue(this.computeType);
    }

    public String computeTypeAsString() {
        return this.computeType;
    }

    public List<EnvironmentVariable> environmentVariables() {
        return this.environmentVariables;
    }

    public Boolean privilegedMode() {
        return this.privilegedMode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.image());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentVariables());
        hashCode = 31 * hashCode + Objects.hashCode(this.privilegedMode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProjectEnvironment)) {
            return false;
        }
        ProjectEnvironment other = (ProjectEnvironment)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.image(), other.image()) && Objects.equals(this.computeTypeAsString(), other.computeTypeAsString()) && Objects.equals(this.environmentVariables(), other.environmentVariables()) && Objects.equals(this.privilegedMode(), other.privilegedMode());
    }

    public String toString() {
        return ToString.builder((String)"ProjectEnvironment").add("Type", (Object)this.typeAsString()).add("Image", (Object)this.image()).add("ComputeType", (Object)this.computeTypeAsString()).add("EnvironmentVariables", this.environmentVariables()).add("PrivilegedMode", (Object)this.privilegedMode()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.of(clazz.cast(this.typeAsString()));
            }
            case "image": {
                return Optional.of(clazz.cast(this.image()));
            }
            case "computeType": {
                return Optional.of(clazz.cast(this.computeTypeAsString()));
            }
            case "environmentVariables": {
                return Optional.of(clazz.cast(this.environmentVariables()));
            }
            case "privilegedMode": {
                return Optional.of(clazz.cast(this.privilegedMode()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProjectEnvironmentMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String image;
        private String computeType;
        private List<EnvironmentVariable> environmentVariables;
        private Boolean privilegedMode;

        private BuilderImpl() {
        }

        private BuilderImpl(ProjectEnvironment model) {
            this.type(model.type);
            this.image(model.image);
            this.computeType(model.computeType);
            this.environmentVariables(model.environmentVariables);
            this.privilegedMode(model.privilegedMode);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(EnvironmentType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getImage() {
            return this.image;
        }

        @Override
        public final Builder image(String image) {
            this.image = image;
            return this;
        }

        public final void setImage(String image) {
            this.image = image;
        }

        public final String getComputeType() {
            return this.computeType;
        }

        @Override
        public final Builder computeType(String computeType) {
            this.computeType = computeType;
            return this;
        }

        @Override
        public final Builder computeType(ComputeType computeType) {
            this.computeType(computeType.toString());
            return this;
        }

        public final void setComputeType(String computeType) {
            this.computeType = computeType;
        }

        public final Collection<EnvironmentVariable.Builder> getEnvironmentVariables() {
            return this.environmentVariables != null ? (Collection)this.environmentVariables.stream().map(EnvironmentVariable::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder environmentVariables(Collection<EnvironmentVariable> environmentVariables) {
            this.environmentVariables = EnvironmentVariablesCopier.copy(environmentVariables);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentVariables(EnvironmentVariable ... environmentVariables) {
            this.environmentVariables(Arrays.asList(environmentVariables));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentVariables(Consumer<EnvironmentVariable.Builder> ... environmentVariables) {
            this.environmentVariables(Stream.of(environmentVariables).map(c -> (EnvironmentVariable)((EnvironmentVariable.Builder)EnvironmentVariable.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEnvironmentVariables(Collection<EnvironmentVariable.BuilderImpl> environmentVariables) {
            this.environmentVariables = EnvironmentVariablesCopier.copyFromBuilder(environmentVariables);
        }

        public final Boolean getPrivilegedMode() {
            return this.privilegedMode;
        }

        @Override
        public final Builder privilegedMode(Boolean privilegedMode) {
            this.privilegedMode = privilegedMode;
            return this;
        }

        public final void setPrivilegedMode(Boolean privilegedMode) {
            this.privilegedMode = privilegedMode;
        }

        public ProjectEnvironment build() {
            return new ProjectEnvironment(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ProjectEnvironment> {
        public Builder type(String var1);

        public Builder type(EnvironmentType var1);

        public Builder image(String var1);

        public Builder computeType(String var1);

        public Builder computeType(ComputeType var1);

        public Builder environmentVariables(Collection<EnvironmentVariable> var1);

        public Builder environmentVariables(EnvironmentVariable ... var1);

        public Builder environmentVariables(Consumer<EnvironmentVariable.Builder> ... var1);

        public Builder privilegedMode(Boolean var1);
    }
}

