/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.codebuild.model.ProjectNamesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListProjectsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListProjectsResponse> {
    private final String nextToken;
    private final List<String> projects;

    private ListProjectsResponse(BuilderImpl builder) {
        this.nextToken = builder.nextToken;
        this.projects = builder.projects;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<String> projects() {
        return this.projects;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        hashCode = 31 * hashCode + (this.projects() == null ? 0 : this.projects().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProjectsResponse)) {
            return false;
        }
        ListProjectsResponse other = (ListProjectsResponse)((Object)obj);
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.projects() == null ^ this.projects() == null) {
            return false;
        }
        return other.projects() == null || other.projects().equals(this.projects());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.projects() != null) {
            sb.append("Projects: ").append(this.projects()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String nextToken;
        private List<String> projects;

        private BuilderImpl() {
        }

        private BuilderImpl(ListProjectsResponse model) {
            this.setNextToken(model.nextToken);
            this.setProjects(model.projects);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<String> getProjects() {
            return this.projects;
        }

        @Override
        public final Builder projects(Collection<String> projects) {
            this.projects = ProjectNamesCopier.copy(projects);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projects(String ... projects) {
            if (this.projects == null) {
                this.projects = new ArrayList<String>(projects.length);
            }
            for (String e : projects) {
                this.projects.add(e);
            }
            return this;
        }

        public final void setProjects(Collection<String> projects) {
            this.projects = ProjectNamesCopier.copy(projects);
        }

        @SafeVarargs
        public final void setProjects(String ... projects) {
            if (this.projects == null) {
                this.projects = new ArrayList<String>(projects.length);
            }
            for (String e : projects) {
                this.projects.add(e);
            }
        }

        public ListProjectsResponse build() {
            return new ListProjectsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListProjectsResponse> {
        public Builder nextToken(String var1);

        public Builder projects(Collection<String> var1);

        public Builder projects(String ... var1);
    }
}

