/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeartifact.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codeartifact.model.CodeartifactResponse;
import software.amazon.awssdk.services.codeartifact.model.PackageSummary;
import software.amazon.awssdk.services.codeartifact.model.PackageSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPackagesResponse
extends CodeartifactResponse
implements ToCopyableBuilder<Builder, ListPackagesResponse> {
    private static final SdkField<List<PackageSummary>> PACKAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("packages").getter(ListPackagesResponse.getter(ListPackagesResponse::packages)).setter(ListPackagesResponse.setter(Builder::packages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PackageSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListPackagesResponse.getter(ListPackagesResponse::nextToken)).setter(ListPackagesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PACKAGES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListPackagesResponse.memberNameToFieldInitializer();
    private final List<PackageSummary> packages;
    private final String nextToken;

    private ListPackagesResponse(BuilderImpl builder) {
        super(builder);
        this.packages = builder.packages;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasPackages() {
        return this.packages != null && !(this.packages instanceof SdkAutoConstructList);
    }

    public final List<PackageSummary> packages() {
        return this.packages;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPackages() ? this.packages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPackagesResponse)) {
            return false;
        }
        ListPackagesResponse other = (ListPackagesResponse)((Object)obj);
        return this.hasPackages() == other.hasPackages() && Objects.equals(this.packages(), other.packages()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListPackagesResponse").add("Packages", this.hasPackages() ? this.packages() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "packages": {
                return Optional.ofNullable(clazz.cast(this.packages()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("packages", PACKAGES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListPackagesResponse, T> g) {
        return obj -> g.apply((ListPackagesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeartifactResponse.BuilderImpl
    implements Builder {
        private List<PackageSummary> packages = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPackagesResponse model) {
            super(model);
            this.packages(model.packages);
            this.nextToken(model.nextToken);
        }

        public final List<PackageSummary.Builder> getPackages() {
            List<PackageSummary.Builder> result = PackageSummaryListCopier.copyToBuilder(this.packages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPackages(Collection<PackageSummary.BuilderImpl> packages) {
            this.packages = PackageSummaryListCopier.copyFromBuilder(packages);
        }

        @Override
        public final Builder packages(Collection<PackageSummary> packages) {
            this.packages = PackageSummaryListCopier.copy(packages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder packages(PackageSummary ... packages) {
            this.packages(Arrays.asList(packages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder packages(Consumer<PackageSummary.Builder> ... packages) {
            this.packages(Stream.of(packages).map(c -> (PackageSummary)((PackageSummary.Builder)PackageSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListPackagesResponse build() {
            return new ListPackagesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CodeartifactResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPackagesResponse> {
        public Builder packages(Collection<PackageSummary> var1);

        public Builder packages(PackageSummary ... var1);

        public Builder packages(Consumer<PackageSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

