/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeartifact.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.codeartifact.model.PackageGroupOriginRestriction;
import software.amazon.awssdk.services.codeartifact.model.PackageGroupOriginRestrictionType;
import software.amazon.awssdk.services.codeartifact.model.PackageGroupOriginRestrictionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PackageGroupOriginConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PackageGroupOriginConfiguration> {
    private static final SdkField<Map<String, PackageGroupOriginRestriction>> RESTRICTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("restrictions").getter(PackageGroupOriginConfiguration.getter(PackageGroupOriginConfiguration::restrictionsAsStrings)).setter(PackageGroupOriginConfiguration.setter(Builder::restrictionsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("restrictions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PackageGroupOriginRestriction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESTRICTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("restrictions", RESTRICTIONS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Map<String, PackageGroupOriginRestriction> restrictions;

    private PackageGroupOriginConfiguration(BuilderImpl builder) {
        this.restrictions = builder.restrictions;
    }

    public final Map<PackageGroupOriginRestrictionType, PackageGroupOriginRestriction> restrictions() {
        return PackageGroupOriginRestrictionsCopier.copyStringToEnum(this.restrictions);
    }

    public final boolean hasRestrictions() {
        return this.restrictions != null && !(this.restrictions instanceof SdkAutoConstructMap);
    }

    public final Map<String, PackageGroupOriginRestriction> restrictionsAsStrings() {
        return this.restrictions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRestrictions() ? this.restrictionsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PackageGroupOriginConfiguration)) {
            return false;
        }
        PackageGroupOriginConfiguration other = (PackageGroupOriginConfiguration)obj;
        return this.hasRestrictions() == other.hasRestrictions() && Objects.equals(this.restrictionsAsStrings(), other.restrictionsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"PackageGroupOriginConfiguration").add("Restrictions", this.hasRestrictions() ? this.restrictionsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "restrictions": {
                return Optional.ofNullable(clazz.cast(this.restrictionsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PackageGroupOriginConfiguration, T> g) {
        return obj -> g.apply((PackageGroupOriginConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, PackageGroupOriginRestriction> restrictions = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PackageGroupOriginConfiguration model) {
            this.restrictionsWithStrings(model.restrictions);
        }

        public final Map<String, PackageGroupOriginRestriction.Builder> getRestrictions() {
            Map<String, PackageGroupOriginRestriction.Builder> result = PackageGroupOriginRestrictionsCopier.copyToBuilder(this.restrictions);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setRestrictions(Map<String, PackageGroupOriginRestriction.BuilderImpl> restrictions) {
            this.restrictions = PackageGroupOriginRestrictionsCopier.copyFromBuilder(restrictions);
        }

        @Override
        public final Builder restrictionsWithStrings(Map<String, PackageGroupOriginRestriction> restrictions) {
            this.restrictions = PackageGroupOriginRestrictionsCopier.copy(restrictions);
            return this;
        }

        @Override
        public final Builder restrictions(Map<PackageGroupOriginRestrictionType, PackageGroupOriginRestriction> restrictions) {
            this.restrictions = PackageGroupOriginRestrictionsCopier.copyEnumToString(restrictions);
            return this;
        }

        public PackageGroupOriginConfiguration build() {
            return new PackageGroupOriginConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PackageGroupOriginConfiguration> {
        public Builder restrictionsWithStrings(Map<String, PackageGroupOriginRestriction> var1);

        public Builder restrictions(Map<PackageGroupOriginRestrictionType, PackageGroupOriginRestriction> var1);
    }
}

