/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeartifact.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codeartifact.CodeartifactClient;
import software.amazon.awssdk.services.codeartifact.internal.UserAgentUtils;
import software.amazon.awssdk.services.codeartifact.model.ListSubPackageGroupsRequest;
import software.amazon.awssdk.services.codeartifact.model.ListSubPackageGroupsResponse;
import software.amazon.awssdk.services.codeartifact.model.PackageGroupSummary;

public class ListSubPackageGroupsIterable
implements SdkIterable<ListSubPackageGroupsResponse> {
    private final CodeartifactClient client;
    private final ListSubPackageGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSubPackageGroupsIterable(CodeartifactClient client, ListSubPackageGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSubPackageGroupsResponseFetcher();
    }

    public Iterator<ListSubPackageGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PackageGroupSummary> packageGroups() {
        Function<ListSubPackageGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.packageGroups() != null) {
                return response.packageGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSubPackageGroupsResponseFetcher
    implements SyncPageFetcher<ListSubPackageGroupsResponse> {
        private ListSubPackageGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListSubPackageGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSubPackageGroupsResponse nextPage(ListSubPackageGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListSubPackageGroupsIterable.this.client.listSubPackageGroups(ListSubPackageGroupsIterable.this.firstRequest);
            }
            return ListSubPackageGroupsIterable.this.client.listSubPackageGroups((ListSubPackageGroupsRequest)((Object)ListSubPackageGroupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

