/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeartifact.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codeartifact.CodeartifactAsyncClient;
import software.amazon.awssdk.services.codeartifact.internal.UserAgentUtils;
import software.amazon.awssdk.services.codeartifact.model.ListRepositoriesRequest;
import software.amazon.awssdk.services.codeartifact.model.ListRepositoriesResponse;
import software.amazon.awssdk.services.codeartifact.model.RepositorySummary;

public class ListRepositoriesPublisher
implements SdkPublisher<ListRepositoriesResponse> {
    private final CodeartifactAsyncClient client;
    private final ListRepositoriesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRepositoriesPublisher(CodeartifactAsyncClient client, ListRepositoriesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRepositoriesPublisher(CodeartifactAsyncClient client, ListRepositoriesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRepositoriesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRepositoriesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RepositorySummary> repositories() {
        Function<ListRepositoriesResponse, Iterator> getIterator = response -> {
            if (response != null && response.repositories() != null) {
                return response.repositories().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListRepositoriesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListRepositoriesResponseFetcher
    implements AsyncPageFetcher<ListRepositoriesResponse> {
        private ListRepositoriesResponseFetcher() {
        }

        public boolean hasNextPage(ListRepositoriesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRepositoriesResponse> nextPage(ListRepositoriesResponse previousPage) {
            if (previousPage == null) {
                return ListRepositoriesPublisher.this.client.listRepositories(ListRepositoriesPublisher.this.firstRequest);
            }
            return ListRepositoriesPublisher.this.client.listRepositories((ListRepositoriesRequest)((Object)ListRepositoriesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

