/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.Distribution;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutSubscriptionFilterRequest
extends CloudWatchLogsRequest
implements ToCopyableBuilder<Builder, PutSubscriptionFilterRequest> {
    private static final SdkField<String> LOG_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutSubscriptionFilterRequest.getter(PutSubscriptionFilterRequest::logGroupName)).setter(PutSubscriptionFilterRequest.setter(Builder::logGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupName").build()}).build();
    private static final SdkField<String> FILTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutSubscriptionFilterRequest.getter(PutSubscriptionFilterRequest::filterName)).setter(PutSubscriptionFilterRequest.setter(Builder::filterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterName").build()}).build();
    private static final SdkField<String> FILTER_PATTERN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutSubscriptionFilterRequest.getter(PutSubscriptionFilterRequest::filterPattern)).setter(PutSubscriptionFilterRequest.setter(Builder::filterPattern)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterPattern").build()}).build();
    private static final SdkField<String> DESTINATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutSubscriptionFilterRequest.getter(PutSubscriptionFilterRequest::destinationArn)).setter(PutSubscriptionFilterRequest.setter(Builder::destinationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationArn").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutSubscriptionFilterRequest.getter(PutSubscriptionFilterRequest::roleArn)).setter(PutSubscriptionFilterRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> DISTRIBUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutSubscriptionFilterRequest.getter(PutSubscriptionFilterRequest::distributionAsString)).setter(PutSubscriptionFilterRequest.setter(Builder::distribution)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("distribution").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_GROUP_NAME_FIELD, FILTER_NAME_FIELD, FILTER_PATTERN_FIELD, DESTINATION_ARN_FIELD, ROLE_ARN_FIELD, DISTRIBUTION_FIELD));
    private final String logGroupName;
    private final String filterName;
    private final String filterPattern;
    private final String destinationArn;
    private final String roleArn;
    private final String distribution;

    private PutSubscriptionFilterRequest(BuilderImpl builder) {
        super(builder);
        this.logGroupName = builder.logGroupName;
        this.filterName = builder.filterName;
        this.filterPattern = builder.filterPattern;
        this.destinationArn = builder.destinationArn;
        this.roleArn = builder.roleArn;
        this.distribution = builder.distribution;
    }

    public String logGroupName() {
        return this.logGroupName;
    }

    public String filterName() {
        return this.filterName;
    }

    public String filterPattern() {
        return this.filterPattern;
    }

    public String destinationArn() {
        return this.destinationArn;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public Distribution distribution() {
        return Distribution.fromValue(this.distribution);
    }

    public String distributionAsString() {
        return this.distribution;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterPattern());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.distributionAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutSubscriptionFilterRequest)) {
            return false;
        }
        PutSubscriptionFilterRequest other = (PutSubscriptionFilterRequest)((Object)obj);
        return Objects.equals(this.logGroupName(), other.logGroupName()) && Objects.equals(this.filterName(), other.filterName()) && Objects.equals(this.filterPattern(), other.filterPattern()) && Objects.equals(this.destinationArn(), other.destinationArn()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.distributionAsString(), other.distributionAsString());
    }

    public String toString() {
        return ToString.builder((String)"PutSubscriptionFilterRequest").add("LogGroupName", (Object)this.logGroupName()).add("FilterName", (Object)this.filterName()).add("FilterPattern", (Object)this.filterPattern()).add("DestinationArn", (Object)this.destinationArn()).add("RoleArn", (Object)this.roleArn()).add("Distribution", (Object)this.distributionAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "logGroupName": {
                return Optional.ofNullable(clazz.cast(this.logGroupName()));
            }
            case "filterName": {
                return Optional.ofNullable(clazz.cast(this.filterName()));
            }
            case "filterPattern": {
                return Optional.ofNullable(clazz.cast(this.filterPattern()));
            }
            case "destinationArn": {
                return Optional.ofNullable(clazz.cast(this.destinationArn()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "distribution": {
                return Optional.ofNullable(clazz.cast(this.distributionAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutSubscriptionFilterRequest, T> g) {
        return obj -> g.apply((PutSubscriptionFilterRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchLogsRequest.BuilderImpl
    implements Builder {
        private String logGroupName;
        private String filterName;
        private String filterPattern;
        private String destinationArn;
        private String roleArn;
        private String distribution;

        private BuilderImpl() {
        }

        private BuilderImpl(PutSubscriptionFilterRequest model) {
            super(model);
            this.logGroupName(model.logGroupName);
            this.filterName(model.filterName);
            this.filterPattern(model.filterPattern);
            this.destinationArn(model.destinationArn);
            this.roleArn(model.roleArn);
            this.distribution(model.distribution);
        }

        public final String getLogGroupName() {
            return this.logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        public final String getFilterName() {
            return this.filterName;
        }

        @Override
        public final Builder filterName(String filterName) {
            this.filterName = filterName;
            return this;
        }

        public final void setFilterName(String filterName) {
            this.filterName = filterName;
        }

        public final String getFilterPattern() {
            return this.filterPattern;
        }

        @Override
        public final Builder filterPattern(String filterPattern) {
            this.filterPattern = filterPattern;
            return this;
        }

        public final void setFilterPattern(String filterPattern) {
            this.filterPattern = filterPattern;
        }

        public final String getDestinationArn() {
            return this.destinationArn;
        }

        @Override
        public final Builder destinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
            return this;
        }

        public final void setDestinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getDistributionAsString() {
            return this.distribution;
        }

        @Override
        public final Builder distribution(String distribution) {
            this.distribution = distribution;
            return this;
        }

        @Override
        public final Builder distribution(Distribution distribution) {
            this.distribution(distribution.toString());
            return this;
        }

        public final void setDistribution(String distribution) {
            this.distribution = distribution;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutSubscriptionFilterRequest build() {
            return new PutSubscriptionFilterRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudWatchLogsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutSubscriptionFilterRequest> {
        public Builder logGroupName(String var1);

        public Builder filterName(String var1);

        public Builder filterPattern(String var1);

        public Builder destinationArn(String var1);

        public Builder roleArn(String var1);

        public Builder distribution(String var1);

        public Builder distribution(Distribution var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

