/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum Distribution {
    RANDOM("Random"),
    BY_LOG_STREAM("ByLogStream"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private Distribution(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Distribution fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(Distribution.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Distribution> knownValues() {
        return Stream.of(Distribution.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

