/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartQueryRequest
extends CloudWatchLogsRequest
implements ToCopyableBuilder<Builder, StartQueryRequest> {
    private static final SdkField<String> LOG_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartQueryRequest.getter(StartQueryRequest::logGroupName)).setter(StartQueryRequest.setter(Builder::logGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupName").build()}).build();
    private static final SdkField<Long> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(StartQueryRequest.getter(StartQueryRequest::startTime)).setter(StartQueryRequest.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<Long> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(StartQueryRequest.getter(StartQueryRequest::endTime)).setter(StartQueryRequest.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()}).build();
    private static final SdkField<String> QUERY_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartQueryRequest.getter(StartQueryRequest::queryString)).setter(StartQueryRequest.setter(Builder::queryString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryString").build()}).build();
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(StartQueryRequest.getter(StartQueryRequest::limit)).setter(StartQueryRequest.setter(Builder::limit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("limit").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_GROUP_NAME_FIELD, START_TIME_FIELD, END_TIME_FIELD, QUERY_STRING_FIELD, LIMIT_FIELD));
    private final String logGroupName;
    private final Long startTime;
    private final Long endTime;
    private final String queryString;
    private final Integer limit;

    private StartQueryRequest(BuilderImpl builder) {
        super(builder);
        this.logGroupName = builder.logGroupName;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.queryString = builder.queryString;
        this.limit = builder.limit;
    }

    public String logGroupName() {
        return this.logGroupName;
    }

    public Long startTime() {
        return this.startTime;
    }

    public Long endTime() {
        return this.endTime;
    }

    public String queryString() {
        return this.queryString;
    }

    public Integer limit() {
        return this.limit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryString());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartQueryRequest)) {
            return false;
        }
        StartQueryRequest other = (StartQueryRequest)((Object)obj);
        return Objects.equals(this.logGroupName(), other.logGroupName()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.queryString(), other.queryString()) && Objects.equals(this.limit(), other.limit());
    }

    public String toString() {
        return ToString.builder((String)"StartQueryRequest").add("LogGroupName", (Object)this.logGroupName()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("QueryString", (Object)this.queryString()).add("Limit", (Object)this.limit()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "logGroupName": {
                return Optional.ofNullable(clazz.cast(this.logGroupName()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "queryString": {
                return Optional.ofNullable(clazz.cast(this.queryString()));
            }
            case "limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartQueryRequest, T> g) {
        return obj -> g.apply((StartQueryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchLogsRequest.BuilderImpl
    implements Builder {
        private String logGroupName;
        private Long startTime;
        private Long endTime;
        private String queryString;
        private Integer limit;

        private BuilderImpl() {
        }

        private BuilderImpl(StartQueryRequest model) {
            super(model);
            this.logGroupName(model.logGroupName);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.queryString(model.queryString);
            this.limit(model.limit);
        }

        public final String getLogGroupName() {
            return this.logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        public final Long getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Long startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Long startTime) {
            this.startTime = startTime;
        }

        public final Long getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Long endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Long endTime) {
            this.endTime = endTime;
        }

        public final String getQueryString() {
            return this.queryString;
        }

        @Override
        public final Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public final void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartQueryRequest build() {
            return new StartQueryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudWatchLogsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartQueryRequest> {
        public Builder logGroupName(String var1);

        public Builder startTime(Long var1);

        public Builder endTime(Long var1);

        public Builder queryString(String var1);

        public Builder limit(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

