/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsAsyncClient;
import software.amazon.awssdk.services.cloudwatchlogs.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeMetricFiltersRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeMetricFiltersResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.MetricFilter;

public class DescribeMetricFiltersPublisher
implements SdkPublisher<DescribeMetricFiltersResponse> {
    private final CloudWatchLogsAsyncClient client;
    private final DescribeMetricFiltersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeMetricFiltersPublisher(CloudWatchLogsAsyncClient client, DescribeMetricFiltersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeMetricFiltersPublisher(CloudWatchLogsAsyncClient client, DescribeMetricFiltersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeMetricFiltersResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeMetricFiltersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<MetricFilter> metricFilters() {
        return this.flatMapIterable(response -> response.metricFilters());
    }

    private class DescribeMetricFiltersResponseFetcher
    implements AsyncPageFetcher<DescribeMetricFiltersResponse> {
        private DescribeMetricFiltersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeMetricFiltersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeMetricFiltersResponse> nextPage(DescribeMetricFiltersResponse previousPage) {
            if (previousPage == null) {
                return DescribeMetricFiltersPublisher.this.client.describeMetricFilters(DescribeMetricFiltersPublisher.this.firstRequest);
            }
            return DescribeMetricFiltersPublisher.this.client.describeMetricFilters((DescribeMetricFiltersRequest)((Object)DescribeMetricFiltersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

