/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsAsyncClient;
import software.amazon.awssdk.services.cloudwatchlogs.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudwatchlogs.model.ListLogGroupsForQueryRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.ListLogGroupsForQueryResponse;

public class ListLogGroupsForQueryPublisher
implements SdkPublisher<ListLogGroupsForQueryResponse> {
    private final CloudWatchLogsAsyncClient client;
    private final ListLogGroupsForQueryRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListLogGroupsForQueryPublisher(CloudWatchLogsAsyncClient client, ListLogGroupsForQueryRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListLogGroupsForQueryPublisher(CloudWatchLogsAsyncClient client, ListLogGroupsForQueryRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListLogGroupsForQueryResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListLogGroupsForQueryResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> logGroupIdentifiers() {
        return this.flatMapIterable(response -> response.logGroupIdentifiers());
    }

    private class ListLogGroupsForQueryResponseFetcher
    implements AsyncPageFetcher<ListLogGroupsForQueryResponse> {
        private ListLogGroupsForQueryResponseFetcher() {
        }

        public boolean hasNextPage(ListLogGroupsForQueryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListLogGroupsForQueryResponse> nextPage(ListLogGroupsForQueryResponse previousPage) {
            if (previousPage == null) {
                return ListLogGroupsForQueryPublisher.this.client.listLogGroupsForQuery(ListLogGroupsForQueryPublisher.this.firstRequest);
            }
            return ListLogGroupsForQueryPublisher.this.client.listLogGroupsForQuery((ListLogGroupsForQueryRequest)((Object)ListLogGroupsForQueryPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

