/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsClient;
import software.amazon.awssdk.services.cloudwatchlogs.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudwatchlogs.model.AggregateLogGroupSummary;
import software.amazon.awssdk.services.cloudwatchlogs.model.ListAggregateLogGroupSummariesRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.ListAggregateLogGroupSummariesResponse;

public class ListAggregateLogGroupSummariesIterable
implements SdkIterable<ListAggregateLogGroupSummariesResponse> {
    private final CloudWatchLogsClient client;
    private final ListAggregateLogGroupSummariesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAggregateLogGroupSummariesIterable(CloudWatchLogsClient client, ListAggregateLogGroupSummariesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAggregateLogGroupSummariesResponseFetcher();
    }

    public Iterator<ListAggregateLogGroupSummariesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AggregateLogGroupSummary> aggregateLogGroupSummaries() {
        Function<ListAggregateLogGroupSummariesResponse, Iterator> getIterator = response -> {
            if (response != null && response.aggregateLogGroupSummaries() != null) {
                return response.aggregateLogGroupSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAggregateLogGroupSummariesResponseFetcher
    implements SyncPageFetcher<ListAggregateLogGroupSummariesResponse> {
        private ListAggregateLogGroupSummariesResponseFetcher() {
        }

        public boolean hasNextPage(ListAggregateLogGroupSummariesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAggregateLogGroupSummariesResponse nextPage(ListAggregateLogGroupSummariesResponse previousPage) {
            if (previousPage == null) {
                return ListAggregateLogGroupSummariesIterable.this.client.listAggregateLogGroupSummaries(ListAggregateLogGroupSummariesIterable.this.firstRequest);
            }
            return ListAggregateLogGroupSummariesIterable.this.client.listAggregateLogGroupSummaries((ListAggregateLogGroupSummariesRequest)((Object)ListAggregateLogGroupSummariesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

