/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.ImportBatch;
import software.amazon.awssdk.services.cloudwatchlogs.model.ImportBatchListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeImportTaskBatchesResponse
extends CloudWatchLogsResponse
implements ToCopyableBuilder<Builder, DescribeImportTaskBatchesResponse> {
    private static final SdkField<String> IMPORT_SOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("importSourceArn").getter(DescribeImportTaskBatchesResponse.getter(DescribeImportTaskBatchesResponse::importSourceArn)).setter(DescribeImportTaskBatchesResponse.setter(Builder::importSourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importSourceArn").build()}).build();
    private static final SdkField<String> IMPORT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("importId").getter(DescribeImportTaskBatchesResponse.getter(DescribeImportTaskBatchesResponse::importId)).setter(DescribeImportTaskBatchesResponse.setter(Builder::importId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importId").build()}).build();
    private static final SdkField<List<ImportBatch>> IMPORT_BATCHES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("importBatches").getter(DescribeImportTaskBatchesResponse.getter(DescribeImportTaskBatchesResponse::importBatches)).setter(DescribeImportTaskBatchesResponse.setter(Builder::importBatches)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importBatches").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ImportBatch::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(DescribeImportTaskBatchesResponse.getter(DescribeImportTaskBatchesResponse::nextToken)).setter(DescribeImportTaskBatchesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMPORT_SOURCE_ARN_FIELD, IMPORT_ID_FIELD, IMPORT_BATCHES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeImportTaskBatchesResponse.memberNameToFieldInitializer();
    private final String importSourceArn;
    private final String importId;
    private final List<ImportBatch> importBatches;
    private final String nextToken;

    private DescribeImportTaskBatchesResponse(BuilderImpl builder) {
        super(builder);
        this.importSourceArn = builder.importSourceArn;
        this.importId = builder.importId;
        this.importBatches = builder.importBatches;
        this.nextToken = builder.nextToken;
    }

    public final String importSourceArn() {
        return this.importSourceArn;
    }

    public final String importId() {
        return this.importId;
    }

    public final boolean hasImportBatches() {
        return this.importBatches != null && !(this.importBatches instanceof SdkAutoConstructList);
    }

    public final List<ImportBatch> importBatches() {
        return this.importBatches;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.importSourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.importId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImportBatches() ? this.importBatches() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImportTaskBatchesResponse)) {
            return false;
        }
        DescribeImportTaskBatchesResponse other = (DescribeImportTaskBatchesResponse)((Object)obj);
        return Objects.equals(this.importSourceArn(), other.importSourceArn()) && Objects.equals(this.importId(), other.importId()) && this.hasImportBatches() == other.hasImportBatches() && Objects.equals(this.importBatches(), other.importBatches()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeImportTaskBatchesResponse").add("ImportSourceArn", (Object)this.importSourceArn()).add("ImportId", (Object)this.importId()).add("ImportBatches", this.hasImportBatches() ? this.importBatches() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "importSourceArn": {
                return Optional.ofNullable(clazz.cast(this.importSourceArn()));
            }
            case "importId": {
                return Optional.ofNullable(clazz.cast(this.importId()));
            }
            case "importBatches": {
                return Optional.ofNullable(clazz.cast(this.importBatches()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("importSourceArn", IMPORT_SOURCE_ARN_FIELD);
        map.put("importId", IMPORT_ID_FIELD);
        map.put("importBatches", IMPORT_BATCHES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeImportTaskBatchesResponse, T> g) {
        return obj -> g.apply((DescribeImportTaskBatchesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchLogsResponse.BuilderImpl
    implements Builder {
        private String importSourceArn;
        private String importId;
        private List<ImportBatch> importBatches = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeImportTaskBatchesResponse model) {
            super(model);
            this.importSourceArn(model.importSourceArn);
            this.importId(model.importId);
            this.importBatches(model.importBatches);
            this.nextToken(model.nextToken);
        }

        public final String getImportSourceArn() {
            return this.importSourceArn;
        }

        public final void setImportSourceArn(String importSourceArn) {
            this.importSourceArn = importSourceArn;
        }

        @Override
        public final Builder importSourceArn(String importSourceArn) {
            this.importSourceArn = importSourceArn;
            return this;
        }

        public final String getImportId() {
            return this.importId;
        }

        public final void setImportId(String importId) {
            this.importId = importId;
        }

        @Override
        public final Builder importId(String importId) {
            this.importId = importId;
            return this;
        }

        public final List<ImportBatch.Builder> getImportBatches() {
            List<ImportBatch.Builder> result = ImportBatchListCopier.copyToBuilder(this.importBatches);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImportBatches(Collection<ImportBatch.BuilderImpl> importBatches) {
            this.importBatches = ImportBatchListCopier.copyFromBuilder(importBatches);
        }

        @Override
        public final Builder importBatches(Collection<ImportBatch> importBatches) {
            this.importBatches = ImportBatchListCopier.copy(importBatches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder importBatches(ImportBatch ... importBatches) {
            this.importBatches(Arrays.asList(importBatches));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder importBatches(Consumer<ImportBatch.Builder> ... importBatches) {
            this.importBatches(Stream.of(importBatches).map(c -> (ImportBatch)((ImportBatch.Builder)ImportBatch.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeImportTaskBatchesResponse build() {
            return new DescribeImportTaskBatchesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudWatchLogsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeImportTaskBatchesResponse> {
        public Builder importSourceArn(String var1);

        public Builder importId(String var1);

        public Builder importBatches(Collection<ImportBatch> var1);

        public Builder importBatches(ImportBatch ... var1);

        public Builder importBatches(Consumer<ImportBatch.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

