/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudwatchlogs.model.DataSource;
import software.amazon.awssdk.services.cloudwatchlogs.model.S3TableIntegrationSourceStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3TableIntegrationSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3TableIntegrationSource> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("identifier").getter(S3TableIntegrationSource.getter(S3TableIntegrationSource::identifier)).setter(S3TableIntegrationSource.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identifier").build()}).build();
    private static final SdkField<DataSource> DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dataSource").getter(S3TableIntegrationSource.getter(S3TableIntegrationSource::dataSource)).setter(S3TableIntegrationSource.setter(Builder::dataSource)).constructor(DataSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSource").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(S3TableIntegrationSource.getter(S3TableIntegrationSource::statusAsString)).setter(S3TableIntegrationSource.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusReason").getter(S3TableIntegrationSource.getter(S3TableIntegrationSource::statusReason)).setter(S3TableIntegrationSource.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()}).build();
    private static final SdkField<Long> CREATED_TIME_STAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("createdTimeStamp").getter(S3TableIntegrationSource.getter(S3TableIntegrationSource::createdTimeStamp)).setter(S3TableIntegrationSource.setter(Builder::createdTimeStamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTimeStamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD, DATA_SOURCE_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, CREATED_TIME_STAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = S3TableIntegrationSource.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String identifier;
    private final DataSource dataSource;
    private final String status;
    private final String statusReason;
    private final Long createdTimeStamp;

    private S3TableIntegrationSource(BuilderImpl builder) {
        this.identifier = builder.identifier;
        this.dataSource = builder.dataSource;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.createdTimeStamp = builder.createdTimeStamp;
    }

    public final String identifier() {
        return this.identifier;
    }

    public final DataSource dataSource() {
        return this.dataSource;
    }

    public final S3TableIntegrationSourceStatus status() {
        return S3TableIntegrationSourceStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final Long createdTimeStamp() {
        return this.createdTimeStamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimeStamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3TableIntegrationSource)) {
            return false;
        }
        S3TableIntegrationSource other = (S3TableIntegrationSource)obj;
        return Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.dataSource(), other.dataSource()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.createdTimeStamp(), other.createdTimeStamp());
    }

    public final String toString() {
        return ToString.builder((String)"S3TableIntegrationSource").add("Identifier", (Object)this.identifier()).add("DataSource", (Object)this.dataSource()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("CreatedTimeStamp", (Object)this.createdTimeStamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "dataSource": {
                return Optional.ofNullable(clazz.cast(this.dataSource()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "createdTimeStamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimeStamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("identifier", IDENTIFIER_FIELD);
        map.put("dataSource", DATA_SOURCE_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        map.put("createdTimeStamp", CREATED_TIME_STAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3TableIntegrationSource, T> g) {
        return obj -> g.apply((S3TableIntegrationSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String identifier;
        private DataSource dataSource;
        private String status;
        private String statusReason;
        private Long createdTimeStamp;

        private BuilderImpl() {
        }

        private BuilderImpl(S3TableIntegrationSource model) {
            this.identifier(model.identifier);
            this.dataSource(model.dataSource);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.createdTimeStamp(model.createdTimeStamp);
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final DataSource.Builder getDataSource() {
            return this.dataSource != null ? this.dataSource.toBuilder() : null;
        }

        public final void setDataSource(DataSource.BuilderImpl dataSource) {
            this.dataSource = dataSource != null ? dataSource.build() : null;
        }

        @Override
        public final Builder dataSource(DataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(S3TableIntegrationSourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final Long getCreatedTimeStamp() {
            return this.createdTimeStamp;
        }

        public final void setCreatedTimeStamp(Long createdTimeStamp) {
            this.createdTimeStamp = createdTimeStamp;
        }

        @Override
        public final Builder createdTimeStamp(Long createdTimeStamp) {
            this.createdTimeStamp = createdTimeStamp;
            return this;
        }

        public S3TableIntegrationSource build() {
            return new S3TableIntegrationSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3TableIntegrationSource> {
        public Builder identifier(String var1);

        public Builder dataSource(DataSource var1);

        default public Builder dataSource(Consumer<DataSource.Builder> dataSource) {
            return this.dataSource((DataSource)((DataSource.Builder)DataSource.builder().applyMutation(dataSource)).build());
        }

        public Builder status(String var1);

        public Builder status(S3TableIntegrationSourceStatus var1);

        public Builder statusReason(String var1);

        public Builder createdTimeStamp(Long var1);
    }
}

