/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchlogs.model.EmitSystemFieldsCopier;
import software.amazon.awssdk.services.cloudwatchlogs.model.MetricTransformation;
import software.amazon.awssdk.services.cloudwatchlogs.model.MetricTransformationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MetricFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MetricFilter> {
    private static final SdkField<String> FILTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("filterName").getter(MetricFilter.getter(MetricFilter::filterName)).setter(MetricFilter.setter(Builder::filterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterName").build()}).build();
    private static final SdkField<String> FILTER_PATTERN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("filterPattern").getter(MetricFilter.getter(MetricFilter::filterPattern)).setter(MetricFilter.setter(Builder::filterPattern)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterPattern").build()}).build();
    private static final SdkField<List<MetricTransformation>> METRIC_TRANSFORMATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("metricTransformations").getter(MetricFilter.getter(MetricFilter::metricTransformations)).setter(MetricFilter.setter(Builder::metricTransformations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricTransformations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricTransformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Long> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("creationTime").getter(MetricFilter.getter(MetricFilter::creationTime)).setter(MetricFilter.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<String> LOG_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logGroupName").getter(MetricFilter.getter(MetricFilter::logGroupName)).setter(MetricFilter.setter(Builder::logGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupName").build()}).build();
    private static final SdkField<Boolean> APPLY_ON_TRANSFORMED_LOGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("applyOnTransformedLogs").getter(MetricFilter.getter(MetricFilter::applyOnTransformedLogs)).setter(MetricFilter.setter(Builder::applyOnTransformedLogs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applyOnTransformedLogs").build()}).build();
    private static final SdkField<String> FIELD_SELECTION_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fieldSelectionCriteria").getter(MetricFilter.getter(MetricFilter::fieldSelectionCriteria)).setter(MetricFilter.setter(Builder::fieldSelectionCriteria)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldSelectionCriteria").build()}).build();
    private static final SdkField<List<String>> EMIT_SYSTEM_FIELD_DIMENSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("emitSystemFieldDimensions").getter(MetricFilter.getter(MetricFilter::emitSystemFieldDimensions)).setter(MetricFilter.setter(Builder::emitSystemFieldDimensions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("emitSystemFieldDimensions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_NAME_FIELD, FILTER_PATTERN_FIELD, METRIC_TRANSFORMATIONS_FIELD, CREATION_TIME_FIELD, LOG_GROUP_NAME_FIELD, APPLY_ON_TRANSFORMED_LOGS_FIELD, FIELD_SELECTION_CRITERIA_FIELD, EMIT_SYSTEM_FIELD_DIMENSIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MetricFilter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String filterName;
    private final String filterPattern;
    private final List<MetricTransformation> metricTransformations;
    private final Long creationTime;
    private final String logGroupName;
    private final Boolean applyOnTransformedLogs;
    private final String fieldSelectionCriteria;
    private final List<String> emitSystemFieldDimensions;

    private MetricFilter(BuilderImpl builder) {
        this.filterName = builder.filterName;
        this.filterPattern = builder.filterPattern;
        this.metricTransformations = builder.metricTransformations;
        this.creationTime = builder.creationTime;
        this.logGroupName = builder.logGroupName;
        this.applyOnTransformedLogs = builder.applyOnTransformedLogs;
        this.fieldSelectionCriteria = builder.fieldSelectionCriteria;
        this.emitSystemFieldDimensions = builder.emitSystemFieldDimensions;
    }

    public final String filterName() {
        return this.filterName;
    }

    public final String filterPattern() {
        return this.filterPattern;
    }

    public final boolean hasMetricTransformations() {
        return this.metricTransformations != null && !(this.metricTransformations instanceof SdkAutoConstructList);
    }

    public final List<MetricTransformation> metricTransformations() {
        return this.metricTransformations;
    }

    public final Long creationTime() {
        return this.creationTime;
    }

    public final String logGroupName() {
        return this.logGroupName;
    }

    public final Boolean applyOnTransformedLogs() {
        return this.applyOnTransformedLogs;
    }

    public final String fieldSelectionCriteria() {
        return this.fieldSelectionCriteria;
    }

    public final boolean hasEmitSystemFieldDimensions() {
        return this.emitSystemFieldDimensions != null && !(this.emitSystemFieldDimensions instanceof SdkAutoConstructList);
    }

    public final List<String> emitSystemFieldDimensions() {
        return this.emitSystemFieldDimensions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterPattern());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricTransformations() ? this.metricTransformations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.applyOnTransformedLogs());
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldSelectionCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEmitSystemFieldDimensions() ? this.emitSystemFieldDimensions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricFilter)) {
            return false;
        }
        MetricFilter other = (MetricFilter)obj;
        return Objects.equals(this.filterName(), other.filterName()) && Objects.equals(this.filterPattern(), other.filterPattern()) && this.hasMetricTransformations() == other.hasMetricTransformations() && Objects.equals(this.metricTransformations(), other.metricTransformations()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.logGroupName(), other.logGroupName()) && Objects.equals(this.applyOnTransformedLogs(), other.applyOnTransformedLogs()) && Objects.equals(this.fieldSelectionCriteria(), other.fieldSelectionCriteria()) && this.hasEmitSystemFieldDimensions() == other.hasEmitSystemFieldDimensions() && Objects.equals(this.emitSystemFieldDimensions(), other.emitSystemFieldDimensions());
    }

    public final String toString() {
        return ToString.builder((String)"MetricFilter").add("FilterName", (Object)this.filterName()).add("FilterPattern", (Object)this.filterPattern()).add("MetricTransformations", this.hasMetricTransformations() ? this.metricTransformations() : null).add("CreationTime", (Object)this.creationTime()).add("LogGroupName", (Object)this.logGroupName()).add("ApplyOnTransformedLogs", (Object)this.applyOnTransformedLogs()).add("FieldSelectionCriteria", (Object)this.fieldSelectionCriteria()).add("EmitSystemFieldDimensions", this.hasEmitSystemFieldDimensions() ? this.emitSystemFieldDimensions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "filterName": {
                return Optional.ofNullable(clazz.cast(this.filterName()));
            }
            case "filterPattern": {
                return Optional.ofNullable(clazz.cast(this.filterPattern()));
            }
            case "metricTransformations": {
                return Optional.ofNullable(clazz.cast(this.metricTransformations()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "logGroupName": {
                return Optional.ofNullable(clazz.cast(this.logGroupName()));
            }
            case "applyOnTransformedLogs": {
                return Optional.ofNullable(clazz.cast(this.applyOnTransformedLogs()));
            }
            case "fieldSelectionCriteria": {
                return Optional.ofNullable(clazz.cast(this.fieldSelectionCriteria()));
            }
            case "emitSystemFieldDimensions": {
                return Optional.ofNullable(clazz.cast(this.emitSystemFieldDimensions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("filterName", FILTER_NAME_FIELD);
        map.put("filterPattern", FILTER_PATTERN_FIELD);
        map.put("metricTransformations", METRIC_TRANSFORMATIONS_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("logGroupName", LOG_GROUP_NAME_FIELD);
        map.put("applyOnTransformedLogs", APPLY_ON_TRANSFORMED_LOGS_FIELD);
        map.put("fieldSelectionCriteria", FIELD_SELECTION_CRITERIA_FIELD);
        map.put("emitSystemFieldDimensions", EMIT_SYSTEM_FIELD_DIMENSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MetricFilter, T> g) {
        return obj -> g.apply((MetricFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String filterName;
        private String filterPattern;
        private List<MetricTransformation> metricTransformations = DefaultSdkAutoConstructList.getInstance();
        private Long creationTime;
        private String logGroupName;
        private Boolean applyOnTransformedLogs;
        private String fieldSelectionCriteria;
        private List<String> emitSystemFieldDimensions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MetricFilter model) {
            this.filterName(model.filterName);
            this.filterPattern(model.filterPattern);
            this.metricTransformations(model.metricTransformations);
            this.creationTime(model.creationTime);
            this.logGroupName(model.logGroupName);
            this.applyOnTransformedLogs(model.applyOnTransformedLogs);
            this.fieldSelectionCriteria(model.fieldSelectionCriteria);
            this.emitSystemFieldDimensions(model.emitSystemFieldDimensions);
        }

        public final String getFilterName() {
            return this.filterName;
        }

        public final void setFilterName(String filterName) {
            this.filterName = filterName;
        }

        @Override
        public final Builder filterName(String filterName) {
            this.filterName = filterName;
            return this;
        }

        public final String getFilterPattern() {
            return this.filterPattern;
        }

        public final void setFilterPattern(String filterPattern) {
            this.filterPattern = filterPattern;
        }

        @Override
        public final Builder filterPattern(String filterPattern) {
            this.filterPattern = filterPattern;
            return this;
        }

        public final List<MetricTransformation.Builder> getMetricTransformations() {
            List<MetricTransformation.Builder> result = MetricTransformationsCopier.copyToBuilder(this.metricTransformations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricTransformations(Collection<MetricTransformation.BuilderImpl> metricTransformations) {
            this.metricTransformations = MetricTransformationsCopier.copyFromBuilder(metricTransformations);
        }

        @Override
        public final Builder metricTransformations(Collection<MetricTransformation> metricTransformations) {
            this.metricTransformations = MetricTransformationsCopier.copy(metricTransformations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricTransformations(MetricTransformation ... metricTransformations) {
            this.metricTransformations(Arrays.asList(metricTransformations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricTransformations(Consumer<MetricTransformation.Builder> ... metricTransformations) {
            this.metricTransformations(Stream.of(metricTransformations).map(c -> (MetricTransformation)((MetricTransformation.Builder)MetricTransformation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Long getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Long creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Long creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getLogGroupName() {
            return this.logGroupName;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final Boolean getApplyOnTransformedLogs() {
            return this.applyOnTransformedLogs;
        }

        public final void setApplyOnTransformedLogs(Boolean applyOnTransformedLogs) {
            this.applyOnTransformedLogs = applyOnTransformedLogs;
        }

        @Override
        public final Builder applyOnTransformedLogs(Boolean applyOnTransformedLogs) {
            this.applyOnTransformedLogs = applyOnTransformedLogs;
            return this;
        }

        public final String getFieldSelectionCriteria() {
            return this.fieldSelectionCriteria;
        }

        public final void setFieldSelectionCriteria(String fieldSelectionCriteria) {
            this.fieldSelectionCriteria = fieldSelectionCriteria;
        }

        @Override
        public final Builder fieldSelectionCriteria(String fieldSelectionCriteria) {
            this.fieldSelectionCriteria = fieldSelectionCriteria;
            return this;
        }

        public final Collection<String> getEmitSystemFieldDimensions() {
            if (this.emitSystemFieldDimensions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.emitSystemFieldDimensions;
        }

        public final void setEmitSystemFieldDimensions(Collection<String> emitSystemFieldDimensions) {
            this.emitSystemFieldDimensions = EmitSystemFieldsCopier.copy(emitSystemFieldDimensions);
        }

        @Override
        public final Builder emitSystemFieldDimensions(Collection<String> emitSystemFieldDimensions) {
            this.emitSystemFieldDimensions = EmitSystemFieldsCopier.copy(emitSystemFieldDimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder emitSystemFieldDimensions(String ... emitSystemFieldDimensions) {
            this.emitSystemFieldDimensions(Arrays.asList(emitSystemFieldDimensions));
            return this;
        }

        public MetricFilter build() {
            return new MetricFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MetricFilter> {
        public Builder filterName(String var1);

        public Builder filterPattern(String var1);

        public Builder metricTransformations(Collection<MetricTransformation> var1);

        public Builder metricTransformations(MetricTransformation ... var1);

        public Builder metricTransformations(Consumer<MetricTransformation.Builder> ... var1);

        public Builder creationTime(Long var1);

        public Builder logGroupName(String var1);

        public Builder applyOnTransformedLogs(Boolean var1);

        public Builder fieldSelectionCriteria(String var1);

        public Builder emitSystemFieldDimensions(Collection<String> var1);

        public Builder emitSystemFieldDimensions(String ... var1);
    }
}

