/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QueryStatistics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, QueryStatistics> {
    private static final SdkField<Double> RECORDS_MATCHED_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("recordsMatched").getter(QueryStatistics.getter(QueryStatistics::recordsMatched)).setter(QueryStatistics.setter(Builder::recordsMatched)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordsMatched").build()}).build();
    private static final SdkField<Double> RECORDS_SCANNED_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("recordsScanned").getter(QueryStatistics.getter(QueryStatistics::recordsScanned)).setter(QueryStatistics.setter(Builder::recordsScanned)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordsScanned").build()}).build();
    private static final SdkField<Double> ESTIMATED_RECORDS_SKIPPED_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("estimatedRecordsSkipped").getter(QueryStatistics.getter(QueryStatistics::estimatedRecordsSkipped)).setter(QueryStatistics.setter(Builder::estimatedRecordsSkipped)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("estimatedRecordsSkipped").build()}).build();
    private static final SdkField<Double> BYTES_SCANNED_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("bytesScanned").getter(QueryStatistics.getter(QueryStatistics::bytesScanned)).setter(QueryStatistics.setter(Builder::bytesScanned)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bytesScanned").build()}).build();
    private static final SdkField<Double> ESTIMATED_BYTES_SKIPPED_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("estimatedBytesSkipped").getter(QueryStatistics.getter(QueryStatistics::estimatedBytesSkipped)).setter(QueryStatistics.setter(Builder::estimatedBytesSkipped)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("estimatedBytesSkipped").build()}).build();
    private static final SdkField<Double> LOG_GROUPS_SCANNED_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("logGroupsScanned").getter(QueryStatistics.getter(QueryStatistics::logGroupsScanned)).setter(QueryStatistics.setter(Builder::logGroupsScanned)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupsScanned").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECORDS_MATCHED_FIELD, RECORDS_SCANNED_FIELD, ESTIMATED_RECORDS_SKIPPED_FIELD, BYTES_SCANNED_FIELD, ESTIMATED_BYTES_SKIPPED_FIELD, LOG_GROUPS_SCANNED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = QueryStatistics.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Double recordsMatched;
    private final Double recordsScanned;
    private final Double estimatedRecordsSkipped;
    private final Double bytesScanned;
    private final Double estimatedBytesSkipped;
    private final Double logGroupsScanned;

    private QueryStatistics(BuilderImpl builder) {
        this.recordsMatched = builder.recordsMatched;
        this.recordsScanned = builder.recordsScanned;
        this.estimatedRecordsSkipped = builder.estimatedRecordsSkipped;
        this.bytesScanned = builder.bytesScanned;
        this.estimatedBytesSkipped = builder.estimatedBytesSkipped;
        this.logGroupsScanned = builder.logGroupsScanned;
    }

    public final Double recordsMatched() {
        return this.recordsMatched;
    }

    public final Double recordsScanned() {
        return this.recordsScanned;
    }

    public final Double estimatedRecordsSkipped() {
        return this.estimatedRecordsSkipped;
    }

    public final Double bytesScanned() {
        return this.bytesScanned;
    }

    public final Double estimatedBytesSkipped() {
        return this.estimatedBytesSkipped;
    }

    public final Double logGroupsScanned() {
        return this.logGroupsScanned;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.recordsMatched());
        hashCode = 31 * hashCode + Objects.hashCode(this.recordsScanned());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedRecordsSkipped());
        hashCode = 31 * hashCode + Objects.hashCode(this.bytesScanned());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedBytesSkipped());
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroupsScanned());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryStatistics)) {
            return false;
        }
        QueryStatistics other = (QueryStatistics)obj;
        return Objects.equals(this.recordsMatched(), other.recordsMatched()) && Objects.equals(this.recordsScanned(), other.recordsScanned()) && Objects.equals(this.estimatedRecordsSkipped(), other.estimatedRecordsSkipped()) && Objects.equals(this.bytesScanned(), other.bytesScanned()) && Objects.equals(this.estimatedBytesSkipped(), other.estimatedBytesSkipped()) && Objects.equals(this.logGroupsScanned(), other.logGroupsScanned());
    }

    public final String toString() {
        return ToString.builder((String)"QueryStatistics").add("RecordsMatched", (Object)this.recordsMatched()).add("RecordsScanned", (Object)this.recordsScanned()).add("EstimatedRecordsSkipped", (Object)this.estimatedRecordsSkipped()).add("BytesScanned", (Object)this.bytesScanned()).add("EstimatedBytesSkipped", (Object)this.estimatedBytesSkipped()).add("LogGroupsScanned", (Object)this.logGroupsScanned()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "recordsMatched": {
                return Optional.ofNullable(clazz.cast(this.recordsMatched()));
            }
            case "recordsScanned": {
                return Optional.ofNullable(clazz.cast(this.recordsScanned()));
            }
            case "estimatedRecordsSkipped": {
                return Optional.ofNullable(clazz.cast(this.estimatedRecordsSkipped()));
            }
            case "bytesScanned": {
                return Optional.ofNullable(clazz.cast(this.bytesScanned()));
            }
            case "estimatedBytesSkipped": {
                return Optional.ofNullable(clazz.cast(this.estimatedBytesSkipped()));
            }
            case "logGroupsScanned": {
                return Optional.ofNullable(clazz.cast(this.logGroupsScanned()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Double>> map = new HashMap<String, SdkField<Double>>();
        map.put("recordsMatched", RECORDS_MATCHED_FIELD);
        map.put("recordsScanned", RECORDS_SCANNED_FIELD);
        map.put("estimatedRecordsSkipped", ESTIMATED_RECORDS_SKIPPED_FIELD);
        map.put("bytesScanned", BYTES_SCANNED_FIELD);
        map.put("estimatedBytesSkipped", ESTIMATED_BYTES_SKIPPED_FIELD);
        map.put("logGroupsScanned", LOG_GROUPS_SCANNED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QueryStatistics, T> g) {
        return obj -> g.apply((QueryStatistics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double recordsMatched;
        private Double recordsScanned;
        private Double estimatedRecordsSkipped;
        private Double bytesScanned;
        private Double estimatedBytesSkipped;
        private Double logGroupsScanned;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryStatistics model) {
            this.recordsMatched(model.recordsMatched);
            this.recordsScanned(model.recordsScanned);
            this.estimatedRecordsSkipped(model.estimatedRecordsSkipped);
            this.bytesScanned(model.bytesScanned);
            this.estimatedBytesSkipped(model.estimatedBytesSkipped);
            this.logGroupsScanned(model.logGroupsScanned);
        }

        public final Double getRecordsMatched() {
            return this.recordsMatched;
        }

        public final void setRecordsMatched(Double recordsMatched) {
            this.recordsMatched = recordsMatched;
        }

        @Override
        public final Builder recordsMatched(Double recordsMatched) {
            this.recordsMatched = recordsMatched;
            return this;
        }

        public final Double getRecordsScanned() {
            return this.recordsScanned;
        }

        public final void setRecordsScanned(Double recordsScanned) {
            this.recordsScanned = recordsScanned;
        }

        @Override
        public final Builder recordsScanned(Double recordsScanned) {
            this.recordsScanned = recordsScanned;
            return this;
        }

        public final Double getEstimatedRecordsSkipped() {
            return this.estimatedRecordsSkipped;
        }

        public final void setEstimatedRecordsSkipped(Double estimatedRecordsSkipped) {
            this.estimatedRecordsSkipped = estimatedRecordsSkipped;
        }

        @Override
        public final Builder estimatedRecordsSkipped(Double estimatedRecordsSkipped) {
            this.estimatedRecordsSkipped = estimatedRecordsSkipped;
            return this;
        }

        public final Double getBytesScanned() {
            return this.bytesScanned;
        }

        public final void setBytesScanned(Double bytesScanned) {
            this.bytesScanned = bytesScanned;
        }

        @Override
        public final Builder bytesScanned(Double bytesScanned) {
            this.bytesScanned = bytesScanned;
            return this;
        }

        public final Double getEstimatedBytesSkipped() {
            return this.estimatedBytesSkipped;
        }

        public final void setEstimatedBytesSkipped(Double estimatedBytesSkipped) {
            this.estimatedBytesSkipped = estimatedBytesSkipped;
        }

        @Override
        public final Builder estimatedBytesSkipped(Double estimatedBytesSkipped) {
            this.estimatedBytesSkipped = estimatedBytesSkipped;
            return this;
        }

        public final Double getLogGroupsScanned() {
            return this.logGroupsScanned;
        }

        public final void setLogGroupsScanned(Double logGroupsScanned) {
            this.logGroupsScanned = logGroupsScanned;
        }

        @Override
        public final Builder logGroupsScanned(Double logGroupsScanned) {
            this.logGroupsScanned = logGroupsScanned;
            return this;
        }

        public QueryStatistics build() {
            return new QueryStatistics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, QueryStatistics> {
        public Builder recordsMatched(Double var1);

        public Builder recordsScanned(Double var1);

        public Builder estimatedRecordsSkipped(Double var1);

        public Builder bytesScanned(Double var1);

        public Builder estimatedBytesSkipped(Double var1);

        public Builder logGroupsScanned(Double var1);
    }
}

