/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RenameKeyEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RenameKeyEntry> {
    private static final SdkField<String> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("key").getter(RenameKeyEntry.getter(RenameKeyEntry::key)).setter(RenameKeyEntry.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("key").build()}).build();
    private static final SdkField<String> RENAME_TO_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("renameTo").getter(RenameKeyEntry.getter(RenameKeyEntry::renameTo)).setter(RenameKeyEntry.setter(Builder::renameTo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("renameTo").build()}).build();
    private static final SdkField<Boolean> OVERWRITE_IF_EXISTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("overwriteIfExists").getter(RenameKeyEntry.getter(RenameKeyEntry::overwriteIfExists)).setter(RenameKeyEntry.setter(Builder::overwriteIfExists)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overwriteIfExists").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, RENAME_TO_FIELD, OVERWRITE_IF_EXISTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RenameKeyEntry.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String key;
    private final String renameTo;
    private final Boolean overwriteIfExists;

    private RenameKeyEntry(BuilderImpl builder) {
        this.key = builder.key;
        this.renameTo = builder.renameTo;
        this.overwriteIfExists = builder.overwriteIfExists;
    }

    public final String key() {
        return this.key;
    }

    public final String renameTo() {
        return this.renameTo;
    }

    public final Boolean overwriteIfExists() {
        return this.overwriteIfExists;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.renameTo());
        hashCode = 31 * hashCode + Objects.hashCode(this.overwriteIfExists());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RenameKeyEntry)) {
            return false;
        }
        RenameKeyEntry other = (RenameKeyEntry)obj;
        return Objects.equals(this.key(), other.key()) && Objects.equals(this.renameTo(), other.renameTo()) && Objects.equals(this.overwriteIfExists(), other.overwriteIfExists());
    }

    public final String toString() {
        return ToString.builder((String)"RenameKeyEntry").add("Key", (Object)this.key()).add("RenameTo", (Object)this.renameTo()).add("OverwriteIfExists", (Object)this.overwriteIfExists()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
            case "renameTo": {
                return Optional.ofNullable(clazz.cast(this.renameTo()));
            }
            case "overwriteIfExists": {
                return Optional.ofNullable(clazz.cast(this.overwriteIfExists()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("key", KEY_FIELD);
        map.put("renameTo", RENAME_TO_FIELD);
        map.put("overwriteIfExists", OVERWRITE_IF_EXISTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RenameKeyEntry, T> g) {
        return obj -> g.apply((RenameKeyEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String key;
        private String renameTo;
        private Boolean overwriteIfExists;

        private BuilderImpl() {
        }

        private BuilderImpl(RenameKeyEntry model) {
            this.key(model.key);
            this.renameTo(model.renameTo);
            this.overwriteIfExists(model.overwriteIfExists);
        }

        public final String getKey() {
            return this.key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final String getRenameTo() {
            return this.renameTo;
        }

        public final void setRenameTo(String renameTo) {
            this.renameTo = renameTo;
        }

        @Override
        public final Builder renameTo(String renameTo) {
            this.renameTo = renameTo;
            return this;
        }

        public final Boolean getOverwriteIfExists() {
            return this.overwriteIfExists;
        }

        public final void setOverwriteIfExists(Boolean overwriteIfExists) {
            this.overwriteIfExists = overwriteIfExists;
        }

        @Override
        public final Builder overwriteIfExists(Boolean overwriteIfExists) {
            this.overwriteIfExists = overwriteIfExists;
            return this;
        }

        public RenameKeyEntry build() {
            return new RenameKeyEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RenameKeyEntry> {
        public Builder key(String var1);

        public Builder renameTo(String var1);

        public Builder overwriteIfExists(Boolean var1);
    }
}

