/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.LogGroupIdentifiersCopier;
import software.amazon.awssdk.services.cloudwatchlogs.model.LogGroupNamesCopier;
import software.amazon.awssdk.services.cloudwatchlogs.model.QueryLanguage;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartQueryRequest
extends CloudWatchLogsRequest
implements ToCopyableBuilder<Builder, StartQueryRequest> {
    private static final SdkField<String> QUERY_LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("queryLanguage").getter(StartQueryRequest.getter(StartQueryRequest::queryLanguageAsString)).setter(StartQueryRequest.setter(Builder::queryLanguage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryLanguage").build()}).build();
    private static final SdkField<String> LOG_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logGroupName").getter(StartQueryRequest.getter(StartQueryRequest::logGroupName)).setter(StartQueryRequest.setter(Builder::logGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupName").build()}).build();
    private static final SdkField<List<String>> LOG_GROUP_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("logGroupNames").getter(StartQueryRequest.getter(StartQueryRequest::logGroupNames)).setter(StartQueryRequest.setter(Builder::logGroupNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> LOG_GROUP_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("logGroupIdentifiers").getter(StartQueryRequest.getter(StartQueryRequest::logGroupIdentifiers)).setter(StartQueryRequest.setter(Builder::logGroupIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupIdentifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Long> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("startTime").getter(StartQueryRequest.getter(StartQueryRequest::startTime)).setter(StartQueryRequest.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<Long> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("endTime").getter(StartQueryRequest.getter(StartQueryRequest::endTime)).setter(StartQueryRequest.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()}).build();
    private static final SdkField<String> QUERY_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("queryString").getter(StartQueryRequest.getter(StartQueryRequest::queryString)).setter(StartQueryRequest.setter(Builder::queryString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryString").build()}).build();
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("limit").getter(StartQueryRequest.getter(StartQueryRequest::limit)).setter(StartQueryRequest.setter(Builder::limit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("limit").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_LANGUAGE_FIELD, LOG_GROUP_NAME_FIELD, LOG_GROUP_NAMES_FIELD, LOG_GROUP_IDENTIFIERS_FIELD, START_TIME_FIELD, END_TIME_FIELD, QUERY_STRING_FIELD, LIMIT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("queryLanguage", QUERY_LANGUAGE_FIELD);
            this.put("logGroupName", LOG_GROUP_NAME_FIELD);
            this.put("logGroupNames", LOG_GROUP_NAMES_FIELD);
            this.put("logGroupIdentifiers", LOG_GROUP_IDENTIFIERS_FIELD);
            this.put("startTime", START_TIME_FIELD);
            this.put("endTime", END_TIME_FIELD);
            this.put("queryString", QUERY_STRING_FIELD);
            this.put("limit", LIMIT_FIELD);
        }
    });
    private final String queryLanguage;
    private final String logGroupName;
    private final List<String> logGroupNames;
    private final List<String> logGroupIdentifiers;
    private final Long startTime;
    private final Long endTime;
    private final String queryString;
    private final Integer limit;

    private StartQueryRequest(BuilderImpl builder) {
        super(builder);
        this.queryLanguage = builder.queryLanguage;
        this.logGroupName = builder.logGroupName;
        this.logGroupNames = builder.logGroupNames;
        this.logGroupIdentifiers = builder.logGroupIdentifiers;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.queryString = builder.queryString;
        this.limit = builder.limit;
    }

    public final QueryLanguage queryLanguage() {
        return QueryLanguage.fromValue(this.queryLanguage);
    }

    public final String queryLanguageAsString() {
        return this.queryLanguage;
    }

    public final String logGroupName() {
        return this.logGroupName;
    }

    public final boolean hasLogGroupNames() {
        return this.logGroupNames != null && !(this.logGroupNames instanceof SdkAutoConstructList);
    }

    public final List<String> logGroupNames() {
        return this.logGroupNames;
    }

    public final boolean hasLogGroupIdentifiers() {
        return this.logGroupIdentifiers != null && !(this.logGroupIdentifiers instanceof SdkAutoConstructList);
    }

    public final List<String> logGroupIdentifiers() {
        return this.logGroupIdentifiers;
    }

    public final Long startTime() {
        return this.startTime;
    }

    public final Long endTime() {
        return this.endTime;
    }

    public final String queryString() {
        return this.queryString;
    }

    public final Integer limit() {
        return this.limit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.queryLanguageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLogGroupNames() ? this.logGroupNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLogGroupIdentifiers() ? this.logGroupIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryString());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartQueryRequest)) {
            return false;
        }
        StartQueryRequest other = (StartQueryRequest)((Object)obj);
        return Objects.equals(this.queryLanguageAsString(), other.queryLanguageAsString()) && Objects.equals(this.logGroupName(), other.logGroupName()) && this.hasLogGroupNames() == other.hasLogGroupNames() && Objects.equals(this.logGroupNames(), other.logGroupNames()) && this.hasLogGroupIdentifiers() == other.hasLogGroupIdentifiers() && Objects.equals(this.logGroupIdentifiers(), other.logGroupIdentifiers()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.queryString(), other.queryString()) && Objects.equals(this.limit(), other.limit());
    }

    public final String toString() {
        return ToString.builder((String)"StartQueryRequest").add("QueryLanguage", (Object)this.queryLanguageAsString()).add("LogGroupName", (Object)this.logGroupName()).add("LogGroupNames", this.hasLogGroupNames() ? this.logGroupNames() : null).add("LogGroupIdentifiers", this.hasLogGroupIdentifiers() ? this.logGroupIdentifiers() : null).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("QueryString", (Object)this.queryString()).add("Limit", (Object)this.limit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "queryLanguage": {
                return Optional.ofNullable(clazz.cast(this.queryLanguageAsString()));
            }
            case "logGroupName": {
                return Optional.ofNullable(clazz.cast(this.logGroupName()));
            }
            case "logGroupNames": {
                return Optional.ofNullable(clazz.cast(this.logGroupNames()));
            }
            case "logGroupIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.logGroupIdentifiers()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "queryString": {
                return Optional.ofNullable(clazz.cast(this.queryString()));
            }
            case "limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StartQueryRequest, T> g) {
        return obj -> g.apply((StartQueryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchLogsRequest.BuilderImpl
    implements Builder {
        private String queryLanguage;
        private String logGroupName;
        private List<String> logGroupNames = DefaultSdkAutoConstructList.getInstance();
        private List<String> logGroupIdentifiers = DefaultSdkAutoConstructList.getInstance();
        private Long startTime;
        private Long endTime;
        private String queryString;
        private Integer limit;

        private BuilderImpl() {
        }

        private BuilderImpl(StartQueryRequest model) {
            super(model);
            this.queryLanguage(model.queryLanguage);
            this.logGroupName(model.logGroupName);
            this.logGroupNames(model.logGroupNames);
            this.logGroupIdentifiers(model.logGroupIdentifiers);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.queryString(model.queryString);
            this.limit(model.limit);
        }

        public final String getQueryLanguage() {
            return this.queryLanguage;
        }

        public final void setQueryLanguage(String queryLanguage) {
            this.queryLanguage = queryLanguage;
        }

        @Override
        public final Builder queryLanguage(String queryLanguage) {
            this.queryLanguage = queryLanguage;
            return this;
        }

        @Override
        public final Builder queryLanguage(QueryLanguage queryLanguage) {
            this.queryLanguage(queryLanguage == null ? null : queryLanguage.toString());
            return this;
        }

        public final String getLogGroupName() {
            return this.logGroupName;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final Collection<String> getLogGroupNames() {
            if (this.logGroupNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.logGroupNames;
        }

        public final void setLogGroupNames(Collection<String> logGroupNames) {
            this.logGroupNames = LogGroupNamesCopier.copy(logGroupNames);
        }

        @Override
        public final Builder logGroupNames(Collection<String> logGroupNames) {
            this.logGroupNames = LogGroupNamesCopier.copy(logGroupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logGroupNames(String ... logGroupNames) {
            this.logGroupNames(Arrays.asList(logGroupNames));
            return this;
        }

        public final Collection<String> getLogGroupIdentifiers() {
            if (this.logGroupIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.logGroupIdentifiers;
        }

        public final void setLogGroupIdentifiers(Collection<String> logGroupIdentifiers) {
            this.logGroupIdentifiers = LogGroupIdentifiersCopier.copy(logGroupIdentifiers);
        }

        @Override
        public final Builder logGroupIdentifiers(Collection<String> logGroupIdentifiers) {
            this.logGroupIdentifiers = LogGroupIdentifiersCopier.copy(logGroupIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logGroupIdentifiers(String ... logGroupIdentifiers) {
            this.logGroupIdentifiers(Arrays.asList(logGroupIdentifiers));
            return this;
        }

        public final Long getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Long startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Long startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Long getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Long endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Long endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getQueryString() {
            return this.queryString;
        }

        public final void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        @Override
        public final Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartQueryRequest build() {
            return new StartQueryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudWatchLogsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartQueryRequest> {
        public Builder queryLanguage(String var1);

        public Builder queryLanguage(QueryLanguage var1);

        public Builder logGroupName(String var1);

        public Builder logGroupNames(Collection<String> var1);

        public Builder logGroupNames(String ... var1);

        public Builder logGroupIdentifiers(Collection<String> var1);

        public Builder logGroupIdentifiers(String ... var1);

        public Builder startTime(Long var1);

        public Builder endTime(Long var1);

        public Builder queryString(String var1);

        public Builder limit(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

