/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.Processor;
import software.amazon.awssdk.services.cloudwatchlogs.model.ProcessorsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutTransformerRequest
extends CloudWatchLogsRequest
implements ToCopyableBuilder<Builder, PutTransformerRequest> {
    private static final SdkField<String> LOG_GROUP_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logGroupIdentifier").getter(PutTransformerRequest.getter(PutTransformerRequest::logGroupIdentifier)).setter(PutTransformerRequest.setter(Builder::logGroupIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupIdentifier").build()}).build();
    private static final SdkField<List<Processor>> TRANSFORMER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("transformerConfig").getter(PutTransformerRequest.getter(PutTransformerRequest::transformerConfig)).setter(PutTransformerRequest.setter(Builder::transformerConfig)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transformerConfig").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Processor::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_GROUP_IDENTIFIER_FIELD, TRANSFORMER_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("logGroupIdentifier", LOG_GROUP_IDENTIFIER_FIELD);
            this.put("transformerConfig", TRANSFORMER_CONFIG_FIELD);
        }
    });
    private final String logGroupIdentifier;
    private final List<Processor> transformerConfig;

    private PutTransformerRequest(BuilderImpl builder) {
        super(builder);
        this.logGroupIdentifier = builder.logGroupIdentifier;
        this.transformerConfig = builder.transformerConfig;
    }

    public final String logGroupIdentifier() {
        return this.logGroupIdentifier;
    }

    public final boolean hasTransformerConfig() {
        return this.transformerConfig != null && !(this.transformerConfig instanceof SdkAutoConstructList);
    }

    public final List<Processor> transformerConfig() {
        return this.transformerConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTransformerConfig() ? this.transformerConfig() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutTransformerRequest)) {
            return false;
        }
        PutTransformerRequest other = (PutTransformerRequest)((Object)obj);
        return Objects.equals(this.logGroupIdentifier(), other.logGroupIdentifier()) && this.hasTransformerConfig() == other.hasTransformerConfig() && Objects.equals(this.transformerConfig(), other.transformerConfig());
    }

    public final String toString() {
        return ToString.builder((String)"PutTransformerRequest").add("LogGroupIdentifier", (Object)this.logGroupIdentifier()).add("TransformerConfig", this.hasTransformerConfig() ? this.transformerConfig() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "logGroupIdentifier": {
                return Optional.ofNullable(clazz.cast(this.logGroupIdentifier()));
            }
            case "transformerConfig": {
                return Optional.ofNullable(clazz.cast(this.transformerConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PutTransformerRequest, T> g) {
        return obj -> g.apply((PutTransformerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchLogsRequest.BuilderImpl
    implements Builder {
        private String logGroupIdentifier;
        private List<Processor> transformerConfig = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutTransformerRequest model) {
            super(model);
            this.logGroupIdentifier(model.logGroupIdentifier);
            this.transformerConfig(model.transformerConfig);
        }

        public final String getLogGroupIdentifier() {
            return this.logGroupIdentifier;
        }

        public final void setLogGroupIdentifier(String logGroupIdentifier) {
            this.logGroupIdentifier = logGroupIdentifier;
        }

        @Override
        public final Builder logGroupIdentifier(String logGroupIdentifier) {
            this.logGroupIdentifier = logGroupIdentifier;
            return this;
        }

        public final List<Processor.Builder> getTransformerConfig() {
            List<Processor.Builder> result = ProcessorsCopier.copyToBuilder(this.transformerConfig);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTransformerConfig(Collection<Processor.BuilderImpl> transformerConfig) {
            this.transformerConfig = ProcessorsCopier.copyFromBuilder(transformerConfig);
        }

        @Override
        public final Builder transformerConfig(Collection<Processor> transformerConfig) {
            this.transformerConfig = ProcessorsCopier.copy(transformerConfig);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transformerConfig(Processor ... transformerConfig) {
            this.transformerConfig(Arrays.asList(transformerConfig));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transformerConfig(Consumer<Processor.Builder> ... transformerConfig) {
            this.transformerConfig(Stream.of(transformerConfig).map(c -> (Processor)((Processor.Builder)Processor.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutTransformerRequest build() {
            return new PutTransformerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudWatchLogsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutTransformerRequest> {
        public Builder logGroupIdentifier(String var1);

        public Builder transformerConfig(Collection<Processor> var1);

        public Builder transformerConfig(Processor ... var1);

        public Builder transformerConfig(Consumer<Processor.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

