/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsClient;
import software.amazon.awssdk.services.cloudwatchlogs.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudwatchlogs.model.AnomalyDetector;
import software.amazon.awssdk.services.cloudwatchlogs.model.ListLogAnomalyDetectorsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.ListLogAnomalyDetectorsResponse;

public class ListLogAnomalyDetectorsIterable
implements SdkIterable<ListLogAnomalyDetectorsResponse> {
    private final CloudWatchLogsClient client;
    private final ListLogAnomalyDetectorsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListLogAnomalyDetectorsIterable(CloudWatchLogsClient client, ListLogAnomalyDetectorsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListLogAnomalyDetectorsResponseFetcher();
    }

    public Iterator<ListLogAnomalyDetectorsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AnomalyDetector> anomalyDetectors() {
        Function<ListLogAnomalyDetectorsResponse, Iterator> getIterator = response -> {
            if (response != null && response.anomalyDetectors() != null) {
                return response.anomalyDetectors().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListLogAnomalyDetectorsResponseFetcher
    implements SyncPageFetcher<ListLogAnomalyDetectorsResponse> {
        private ListLogAnomalyDetectorsResponseFetcher() {
        }

        public boolean hasNextPage(ListLogAnomalyDetectorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListLogAnomalyDetectorsResponse nextPage(ListLogAnomalyDetectorsResponse previousPage) {
            if (previousPage == null) {
                return ListLogAnomalyDetectorsIterable.this.client.listLogAnomalyDetectors(ListLogAnomalyDetectorsIterable.this.firstRequest);
            }
            return ListLogAnomalyDetectorsIterable.this.client.listLogAnomalyDetectors((ListLogAnomalyDetectorsRequest)((Object)ListLogAnomalyDetectorsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

