/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateExportTaskRequest
extends CloudWatchLogsRequest
implements ToCopyableBuilder<Builder, CreateExportTaskRequest> {
    private static final SdkField<String> TASK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskName").getter(CreateExportTaskRequest.getter(CreateExportTaskRequest::taskName)).setter(CreateExportTaskRequest.setter(Builder::taskName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskName").build()}).build();
    private static final SdkField<String> LOG_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logGroupName").getter(CreateExportTaskRequest.getter(CreateExportTaskRequest::logGroupName)).setter(CreateExportTaskRequest.setter(Builder::logGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupName").build()}).build();
    private static final SdkField<String> LOG_STREAM_NAME_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logStreamNamePrefix").getter(CreateExportTaskRequest.getter(CreateExportTaskRequest::logStreamNamePrefix)).setter(CreateExportTaskRequest.setter(Builder::logStreamNamePrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logStreamNamePrefix").build()}).build();
    private static final SdkField<Long> FROM_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("from").getter(CreateExportTaskRequest.getter(CreateExportTaskRequest::from)).setter(CreateExportTaskRequest.setter(Builder::from)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("from").build()}).build();
    private static final SdkField<Long> TO_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("to").getter(CreateExportTaskRequest.getter(CreateExportTaskRequest::to)).setter(CreateExportTaskRequest.setter(Builder::to)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("to").build()}).build();
    private static final SdkField<String> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("destination").getter(CreateExportTaskRequest.getter(CreateExportTaskRequest::destination)).setter(CreateExportTaskRequest.setter(Builder::destination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()}).build();
    private static final SdkField<String> DESTINATION_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("destinationPrefix").getter(CreateExportTaskRequest.getter(CreateExportTaskRequest::destinationPrefix)).setter(CreateExportTaskRequest.setter(Builder::destinationPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationPrefix").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_NAME_FIELD, LOG_GROUP_NAME_FIELD, LOG_STREAM_NAME_PREFIX_FIELD, FROM_FIELD, TO_FIELD, DESTINATION_FIELD, DESTINATION_PREFIX_FIELD));
    private final String taskName;
    private final String logGroupName;
    private final String logStreamNamePrefix;
    private final Long from;
    private final Long to;
    private final String destination;
    private final String destinationPrefix;

    private CreateExportTaskRequest(BuilderImpl builder) {
        super(builder);
        this.taskName = builder.taskName;
        this.logGroupName = builder.logGroupName;
        this.logStreamNamePrefix = builder.logStreamNamePrefix;
        this.from = builder.from;
        this.to = builder.to;
        this.destination = builder.destination;
        this.destinationPrefix = builder.destinationPrefix;
    }

    public final String taskName() {
        return this.taskName;
    }

    public final String logGroupName() {
        return this.logGroupName;
    }

    public final String logStreamNamePrefix() {
        return this.logStreamNamePrefix;
    }

    public final Long from() {
        return this.from;
    }

    public final Long to() {
        return this.to;
    }

    public final String destination() {
        return this.destination;
    }

    public final String destinationPrefix() {
        return this.destinationPrefix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.taskName());
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.logStreamNamePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.from());
        hashCode = 31 * hashCode + Objects.hashCode(this.to());
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationPrefix());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateExportTaskRequest)) {
            return false;
        }
        CreateExportTaskRequest other = (CreateExportTaskRequest)((Object)obj);
        return Objects.equals(this.taskName(), other.taskName()) && Objects.equals(this.logGroupName(), other.logGroupName()) && Objects.equals(this.logStreamNamePrefix(), other.logStreamNamePrefix()) && Objects.equals(this.from(), other.from()) && Objects.equals(this.to(), other.to()) && Objects.equals(this.destination(), other.destination()) && Objects.equals(this.destinationPrefix(), other.destinationPrefix());
    }

    public final String toString() {
        return ToString.builder((String)"CreateExportTaskRequest").add("TaskName", (Object)this.taskName()).add("LogGroupName", (Object)this.logGroupName()).add("LogStreamNamePrefix", (Object)this.logStreamNamePrefix()).add("From", (Object)this.from()).add("To", (Object)this.to()).add("Destination", (Object)this.destination()).add("DestinationPrefix", (Object)this.destinationPrefix()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "taskName": {
                return Optional.ofNullable(clazz.cast(this.taskName()));
            }
            case "logGroupName": {
                return Optional.ofNullable(clazz.cast(this.logGroupName()));
            }
            case "logStreamNamePrefix": {
                return Optional.ofNullable(clazz.cast(this.logStreamNamePrefix()));
            }
            case "from": {
                return Optional.ofNullable(clazz.cast(this.from()));
            }
            case "to": {
                return Optional.ofNullable(clazz.cast(this.to()));
            }
            case "destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
            case "destinationPrefix": {
                return Optional.ofNullable(clazz.cast(this.destinationPrefix()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateExportTaskRequest, T> g) {
        return obj -> g.apply((CreateExportTaskRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchLogsRequest.BuilderImpl
    implements Builder {
        private String taskName;
        private String logGroupName;
        private String logStreamNamePrefix;
        private Long from;
        private Long to;
        private String destination;
        private String destinationPrefix;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateExportTaskRequest model) {
            super(model);
            this.taskName(model.taskName);
            this.logGroupName(model.logGroupName);
            this.logStreamNamePrefix(model.logStreamNamePrefix);
            this.from(model.from);
            this.to(model.to);
            this.destination(model.destination);
            this.destinationPrefix(model.destinationPrefix);
        }

        public final String getTaskName() {
            return this.taskName;
        }

        @Override
        public final Builder taskName(String taskName) {
            this.taskName = taskName;
            return this;
        }

        public final void setTaskName(String taskName) {
            this.taskName = taskName;
        }

        public final String getLogGroupName() {
            return this.logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        public final String getLogStreamNamePrefix() {
            return this.logStreamNamePrefix;
        }

        @Override
        public final Builder logStreamNamePrefix(String logStreamNamePrefix) {
            this.logStreamNamePrefix = logStreamNamePrefix;
            return this;
        }

        public final void setLogStreamNamePrefix(String logStreamNamePrefix) {
            this.logStreamNamePrefix = logStreamNamePrefix;
        }

        public final Long getFrom() {
            return this.from;
        }

        @Override
        public final Builder from(Long from) {
            this.from = from;
            return this;
        }

        public final void setFrom(Long from) {
            this.from = from;
        }

        public final Long getTo() {
            return this.to;
        }

        @Override
        public final Builder to(Long to) {
            this.to = to;
            return this;
        }

        public final void setTo(Long to) {
            this.to = to;
        }

        public final String getDestination() {
            return this.destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        public final String getDestinationPrefix() {
            return this.destinationPrefix;
        }

        @Override
        public final Builder destinationPrefix(String destinationPrefix) {
            this.destinationPrefix = destinationPrefix;
            return this;
        }

        public final void setDestinationPrefix(String destinationPrefix) {
            this.destinationPrefix = destinationPrefix;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateExportTaskRequest build() {
            return new CreateExportTaskRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudWatchLogsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateExportTaskRequest> {
        public Builder taskName(String var1);

        public Builder logGroupName(String var1);

        public Builder logStreamNamePrefix(String var1);

        public Builder from(Long var1);

        public Builder to(Long var1);

        public Builder destination(String var1);

        public Builder destinationPrefix(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

