/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.QueryResultsCopier;
import software.amazon.awssdk.services.cloudwatchlogs.model.QueryStatistics;
import software.amazon.awssdk.services.cloudwatchlogs.model.QueryStatus;
import software.amazon.awssdk.services.cloudwatchlogs.model.ResultField;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetQueryResultsResponse
extends CloudWatchLogsResponse
implements ToCopyableBuilder<Builder, GetQueryResultsResponse> {
    private static final SdkField<List<List<ResultField>>> RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("results").getter(GetQueryResultsResponse.getter(GetQueryResultsResponse::results)).setter(GetQueryResultsResponse.setter(Builder::results)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("results").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResultField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<QueryStatistics> STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("statistics").getter(GetQueryResultsResponse.getter(GetQueryResultsResponse::statistics)).setter(GetQueryResultsResponse.setter(Builder::statistics)).constructor(QueryStatistics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statistics").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetQueryResultsResponse.getter(GetQueryResultsResponse::statusAsString)).setter(GetQueryResultsResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULTS_FIELD, STATISTICS_FIELD, STATUS_FIELD));
    private final List<List<ResultField>> results;
    private final QueryStatistics statistics;
    private final String status;

    private GetQueryResultsResponse(BuilderImpl builder) {
        super(builder);
        this.results = builder.results;
        this.statistics = builder.statistics;
        this.status = builder.status;
    }

    public final boolean hasResults() {
        return this.results != null && !(this.results instanceof SdkAutoConstructList);
    }

    public final List<List<ResultField>> results() {
        return this.results;
    }

    public final QueryStatistics statistics() {
        return this.statistics;
    }

    public final QueryStatus status() {
        return QueryStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResults() ? this.results() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statistics());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetQueryResultsResponse)) {
            return false;
        }
        GetQueryResultsResponse other = (GetQueryResultsResponse)((Object)obj);
        return this.hasResults() == other.hasResults() && Objects.equals(this.results(), other.results()) && Objects.equals(this.statistics(), other.statistics()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetQueryResultsResponse").add("Results", this.hasResults() ? this.results() : null).add("Statistics", (Object)this.statistics()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "results": {
                return Optional.ofNullable(clazz.cast(this.results()));
            }
            case "statistics": {
                return Optional.ofNullable(clazz.cast(this.statistics()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetQueryResultsResponse, T> g) {
        return obj -> g.apply((GetQueryResultsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchLogsResponse.BuilderImpl
    implements Builder {
        private List<List<ResultField>> results = DefaultSdkAutoConstructList.getInstance();
        private QueryStatistics statistics;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(GetQueryResultsResponse model) {
            super(model);
            this.results(model.results);
            this.statistics(model.statistics);
            this.status(model.status);
        }

        public final Collection<? extends Collection<ResultField>> getResults() {
            if (this.results instanceof SdkAutoConstructList) {
                return null;
            }
            return this.results;
        }

        @Override
        public final Builder results(Collection<? extends Collection<ResultField>> results) {
            this.results = QueryResultsCopier.copy(results);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder results(Collection<ResultField> ... results) {
            this.results((Collection<? extends Collection<ResultField>>)Arrays.asList(results));
            return this;
        }

        public final void setResults(Collection<? extends Collection<ResultField>> results) {
            this.results = QueryResultsCopier.copy(results);
        }

        public final QueryStatistics.Builder getStatistics() {
            return this.statistics != null ? this.statistics.toBuilder() : null;
        }

        @Override
        public final Builder statistics(QueryStatistics statistics) {
            this.statistics = statistics;
            return this;
        }

        public final void setStatistics(QueryStatistics.BuilderImpl statistics) {
            this.statistics = statistics != null ? statistics.build() : null;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(QueryStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public GetQueryResultsResponse build() {
            return new GetQueryResultsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudWatchLogsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetQueryResultsResponse> {
        public Builder results(Collection<? extends Collection<ResultField>> var1);

        public Builder results(Collection<ResultField> ... var1);

        public Builder statistics(QueryStatistics var1);

        default public Builder statistics(Consumer<QueryStatistics.Builder> statistics) {
            return this.statistics((QueryStatistics)((QueryStatistics.Builder)QueryStatistics.builder().applyMutation(statistics)).build());
        }

        public Builder status(String var1);

        public Builder status(QueryStatus var1);
    }
}

