/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.ResourcePoliciesCopier;
import software.amazon.awssdk.services.cloudwatchlogs.model.ResourcePolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeResourcePoliciesResponse
extends CloudWatchLogsResponse
implements ToCopyableBuilder<Builder, DescribeResourcePoliciesResponse> {
    private static final SdkField<List<ResourcePolicy>> RESOURCE_POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeResourcePoliciesResponse.getter(DescribeResourcePoliciesResponse::resourcePolicies)).setter(DescribeResourcePoliciesResponse.setter(Builder::resourcePolicies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourcePolicies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourcePolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeResourcePoliciesResponse.getter(DescribeResourcePoliciesResponse::nextToken)).setter(DescribeResourcePoliciesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_POLICIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<ResourcePolicy> resourcePolicies;
    private final String nextToken;

    private DescribeResourcePoliciesResponse(BuilderImpl builder) {
        super(builder);
        this.resourcePolicies = builder.resourcePolicies;
        this.nextToken = builder.nextToken;
    }

    public boolean hasResourcePolicies() {
        return this.resourcePolicies != null && !(this.resourcePolicies instanceof SdkAutoConstructList);
    }

    public List<ResourcePolicy> resourcePolicies() {
        return this.resourcePolicies;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourcePolicies());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeResourcePoliciesResponse)) {
            return false;
        }
        DescribeResourcePoliciesResponse other = (DescribeResourcePoliciesResponse)((Object)obj);
        return Objects.equals(this.resourcePolicies(), other.resourcePolicies()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeResourcePoliciesResponse").add("ResourcePolicies", this.resourcePolicies()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourcePolicies": {
                return Optional.ofNullable(clazz.cast(this.resourcePolicies()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeResourcePoliciesResponse, T> g) {
        return obj -> g.apply((DescribeResourcePoliciesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchLogsResponse.BuilderImpl
    implements Builder {
        private List<ResourcePolicy> resourcePolicies = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeResourcePoliciesResponse model) {
            super(model);
            this.resourcePolicies(model.resourcePolicies);
            this.nextToken(model.nextToken);
        }

        public final Collection<ResourcePolicy.Builder> getResourcePolicies() {
            return this.resourcePolicies != null ? (Collection)this.resourcePolicies.stream().map(ResourcePolicy::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourcePolicies(Collection<ResourcePolicy> resourcePolicies) {
            this.resourcePolicies = ResourcePoliciesCopier.copy(resourcePolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourcePolicies(ResourcePolicy ... resourcePolicies) {
            this.resourcePolicies(Arrays.asList(resourcePolicies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourcePolicies(Consumer<ResourcePolicy.Builder> ... resourcePolicies) {
            this.resourcePolicies(Stream.of(resourcePolicies).map(c -> (ResourcePolicy)((ResourcePolicy.Builder)ResourcePolicy.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResourcePolicies(Collection<ResourcePolicy.BuilderImpl> resourcePolicies) {
            this.resourcePolicies = ResourcePoliciesCopier.copyFromBuilder(resourcePolicies);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeResourcePoliciesResponse build() {
            return new DescribeResourcePoliciesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudWatchLogsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeResourcePoliciesResponse> {
        public Builder resourcePolicies(Collection<ResourcePolicy> var1);

        public Builder resourcePolicies(ResourcePolicy ... var1);

        public Builder resourcePolicies(Consumer<ResourcePolicy.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

