/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudwatchlogs.model.Distribution;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SubscriptionFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SubscriptionFilter> {
    private static final SdkField<String> FILTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SubscriptionFilter.getter(SubscriptionFilter::filterName)).setter(SubscriptionFilter.setter(Builder::filterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterName").build()}).build();
    private static final SdkField<String> LOG_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SubscriptionFilter.getter(SubscriptionFilter::logGroupName)).setter(SubscriptionFilter.setter(Builder::logGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupName").build()}).build();
    private static final SdkField<String> FILTER_PATTERN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SubscriptionFilter.getter(SubscriptionFilter::filterPattern)).setter(SubscriptionFilter.setter(Builder::filterPattern)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterPattern").build()}).build();
    private static final SdkField<String> DESTINATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SubscriptionFilter.getter(SubscriptionFilter::destinationArn)).setter(SubscriptionFilter.setter(Builder::destinationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationArn").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SubscriptionFilter.getter(SubscriptionFilter::roleArn)).setter(SubscriptionFilter.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> DISTRIBUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SubscriptionFilter.getter(SubscriptionFilter::distributionAsString)).setter(SubscriptionFilter.setter(Builder::distribution)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("distribution").build()}).build();
    private static final SdkField<Long> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(SubscriptionFilter.getter(SubscriptionFilter::creationTime)).setter(SubscriptionFilter.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_NAME_FIELD, LOG_GROUP_NAME_FIELD, FILTER_PATTERN_FIELD, DESTINATION_ARN_FIELD, ROLE_ARN_FIELD, DISTRIBUTION_FIELD, CREATION_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String filterName;
    private final String logGroupName;
    private final String filterPattern;
    private final String destinationArn;
    private final String roleArn;
    private final String distribution;
    private final Long creationTime;

    private SubscriptionFilter(BuilderImpl builder) {
        this.filterName = builder.filterName;
        this.logGroupName = builder.logGroupName;
        this.filterPattern = builder.filterPattern;
        this.destinationArn = builder.destinationArn;
        this.roleArn = builder.roleArn;
        this.distribution = builder.distribution;
        this.creationTime = builder.creationTime;
    }

    public String filterName() {
        return this.filterName;
    }

    public String logGroupName() {
        return this.logGroupName;
    }

    public String filterPattern() {
        return this.filterPattern;
    }

    public String destinationArn() {
        return this.destinationArn;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public Distribution distribution() {
        return Distribution.fromValue(this.distribution);
    }

    public String distributionAsString() {
        return this.distribution;
    }

    public Long creationTime() {
        return this.creationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterPattern());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.distributionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubscriptionFilter)) {
            return false;
        }
        SubscriptionFilter other = (SubscriptionFilter)obj;
        return Objects.equals(this.filterName(), other.filterName()) && Objects.equals(this.logGroupName(), other.logGroupName()) && Objects.equals(this.filterPattern(), other.filterPattern()) && Objects.equals(this.destinationArn(), other.destinationArn()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.distributionAsString(), other.distributionAsString()) && Objects.equals(this.creationTime(), other.creationTime());
    }

    public String toString() {
        return ToString.builder((String)"SubscriptionFilter").add("FilterName", (Object)this.filterName()).add("LogGroupName", (Object)this.logGroupName()).add("FilterPattern", (Object)this.filterPattern()).add("DestinationArn", (Object)this.destinationArn()).add("RoleArn", (Object)this.roleArn()).add("Distribution", (Object)this.distributionAsString()).add("CreationTime", (Object)this.creationTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "filterName": {
                return Optional.ofNullable(clazz.cast(this.filterName()));
            }
            case "logGroupName": {
                return Optional.ofNullable(clazz.cast(this.logGroupName()));
            }
            case "filterPattern": {
                return Optional.ofNullable(clazz.cast(this.filterPattern()));
            }
            case "destinationArn": {
                return Optional.ofNullable(clazz.cast(this.destinationArn()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "distribution": {
                return Optional.ofNullable(clazz.cast(this.distributionAsString()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SubscriptionFilter, T> g) {
        return obj -> g.apply((SubscriptionFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String filterName;
        private String logGroupName;
        private String filterPattern;
        private String destinationArn;
        private String roleArn;
        private String distribution;
        private Long creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(SubscriptionFilter model) {
            this.filterName(model.filterName);
            this.logGroupName(model.logGroupName);
            this.filterPattern(model.filterPattern);
            this.destinationArn(model.destinationArn);
            this.roleArn(model.roleArn);
            this.distribution(model.distribution);
            this.creationTime(model.creationTime);
        }

        public final String getFilterName() {
            return this.filterName;
        }

        @Override
        public final Builder filterName(String filterName) {
            this.filterName = filterName;
            return this;
        }

        public final void setFilterName(String filterName) {
            this.filterName = filterName;
        }

        public final String getLogGroupName() {
            return this.logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        public final String getFilterPattern() {
            return this.filterPattern;
        }

        @Override
        public final Builder filterPattern(String filterPattern) {
            this.filterPattern = filterPattern;
            return this;
        }

        public final void setFilterPattern(String filterPattern) {
            this.filterPattern = filterPattern;
        }

        public final String getDestinationArn() {
            return this.destinationArn;
        }

        @Override
        public final Builder destinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
            return this;
        }

        public final void setDestinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getDistribution() {
            return this.distribution;
        }

        @Override
        public final Builder distribution(String distribution) {
            this.distribution = distribution;
            return this;
        }

        @Override
        public final Builder distribution(Distribution distribution) {
            this.distribution(distribution == null ? null : distribution.toString());
            return this;
        }

        public final void setDistribution(String distribution) {
            this.distribution = distribution;
        }

        public final Long getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Long creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Long creationTime) {
            this.creationTime = creationTime;
        }

        public SubscriptionFilter build() {
            return new SubscriptionFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SubscriptionFilter> {
        public Builder filterName(String var1);

        public Builder logGroupName(String var1);

        public Builder filterPattern(String var1);

        public Builder destinationArn(String var1);

        public Builder roleArn(String var1);

        public Builder distribution(String var1);

        public Builder distribution(Distribution var1);

        public Builder creationTime(Long var1);
    }
}

