/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a cross-account destination that receives subscription log events.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Destination implements SdkPojo, Serializable, ToCopyableBuilder<Destination.Builder, Destination> {
    private static final SdkField<String> DESTINATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Destination::destinationName)).setter(setter(Builder::destinationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationName").build()).build();

    private static final SdkField<String> TARGET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Destination::targetArn)).setter(setter(Builder::targetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetArn").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Destination::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> ACCESS_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Destination::accessPolicy)).setter(setter(Builder::accessPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessPolicy").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Destination::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Long> CREATION_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(Destination::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_NAME_FIELD,
            TARGET_ARN_FIELD, ROLE_ARN_FIELD, ACCESS_POLICY_FIELD, ARN_FIELD, CREATION_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String destinationName;

    private final String targetArn;

    private final String roleArn;

    private final String accessPolicy;

    private final String arn;

    private final Long creationTime;

    private Destination(BuilderImpl builder) {
        this.destinationName = builder.destinationName;
        this.targetArn = builder.targetArn;
        this.roleArn = builder.roleArn;
        this.accessPolicy = builder.accessPolicy;
        this.arn = builder.arn;
        this.creationTime = builder.creationTime;
    }

    /**
     * <p>
     * The name of the destination.
     * </p>
     * 
     * @return The name of the destination.
     */
    public String destinationName() {
        return destinationName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the physical target to where the log events are delivered (for example, a
     * Kinesis stream).
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the physical target to where the log events are delivered (for example,
     *         a Kinesis stream).
     */
    public String targetArn() {
        return targetArn;
    }

    /**
     * <p>
     * A role for impersonation, used when delivering log events to the target.
     * </p>
     * 
     * @return A role for impersonation, used when delivering log events to the target.
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * An IAM policy document that governs which AWS accounts can create subscription filters against this destination.
     * </p>
     * 
     * @return An IAM policy document that governs which AWS accounts can create subscription filters against this
     *         destination.
     */
    public String accessPolicy() {
        return accessPolicy;
    }

    /**
     * <p>
     * The ARN of this destination.
     * </p>
     * 
     * @return The ARN of this destination.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The creation time of the destination, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC.
     * </p>
     * 
     * @return The creation time of the destination, expressed as the number of milliseconds after Jan 1, 1970 00:00:00
     *         UTC.
     */
    public Long creationTime() {
        return creationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(destinationName());
        hashCode = 31 * hashCode + Objects.hashCode(targetArn());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(accessPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Destination)) {
            return false;
        }
        Destination other = (Destination) obj;
        return Objects.equals(destinationName(), other.destinationName()) && Objects.equals(targetArn(), other.targetArn())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(accessPolicy(), other.accessPolicy())
                && Objects.equals(arn(), other.arn()) && Objects.equals(creationTime(), other.creationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Destination").add("DestinationName", destinationName()).add("TargetArn", targetArn())
                .add("RoleArn", roleArn()).add("AccessPolicy", accessPolicy()).add("Arn", arn())
                .add("CreationTime", creationTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "destinationName":
            return Optional.ofNullable(clazz.cast(destinationName()));
        case "targetArn":
            return Optional.ofNullable(clazz.cast(targetArn()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "accessPolicy":
            return Optional.ofNullable(clazz.cast(accessPolicy()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Destination, T> g) {
        return obj -> g.apply((Destination) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Destination> {
        /**
         * <p>
         * The name of the destination.
         * </p>
         * 
         * @param destinationName
         *        The name of the destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationName(String destinationName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the physical target to where the log events are delivered (for example, a
         * Kinesis stream).
         * </p>
         * 
         * @param targetArn
         *        The Amazon Resource Name (ARN) of the physical target to where the log events are delivered (for
         *        example, a Kinesis stream).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetArn(String targetArn);

        /**
         * <p>
         * A role for impersonation, used when delivering log events to the target.
         * </p>
         * 
         * @param roleArn
         *        A role for impersonation, used when delivering log events to the target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * An IAM policy document that governs which AWS accounts can create subscription filters against this
         * destination.
         * </p>
         * 
         * @param accessPolicy
         *        An IAM policy document that governs which AWS accounts can create subscription filters against this
         *        destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessPolicy(String accessPolicy);

        /**
         * <p>
         * The ARN of this destination.
         * </p>
         * 
         * @param arn
         *        The ARN of this destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The creation time of the destination, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC.
         * </p>
         * 
         * @param creationTime
         *        The creation time of the destination, expressed as the number of milliseconds after Jan 1, 1970
         *        00:00:00 UTC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Long creationTime);
    }

    static final class BuilderImpl implements Builder {
        private String destinationName;

        private String targetArn;

        private String roleArn;

        private String accessPolicy;

        private String arn;

        private Long creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Destination model) {
            destinationName(model.destinationName);
            targetArn(model.targetArn);
            roleArn(model.roleArn);
            accessPolicy(model.accessPolicy);
            arn(model.arn);
            creationTime(model.creationTime);
        }

        public final String getDestinationName() {
            return destinationName;
        }

        @Override
        public final Builder destinationName(String destinationName) {
            this.destinationName = destinationName;
            return this;
        }

        public final void setDestinationName(String destinationName) {
            this.destinationName = destinationName;
        }

        public final String getTargetArn() {
            return targetArn;
        }

        @Override
        public final Builder targetArn(String targetArn) {
            this.targetArn = targetArn;
            return this;
        }

        public final void setTargetArn(String targetArn) {
            this.targetArn = targetArn;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getAccessPolicy() {
            return accessPolicy;
        }

        @Override
        public final Builder accessPolicy(String accessPolicy) {
            this.accessPolicy = accessPolicy;
            return this;
        }

        public final void setAccessPolicy(String accessPolicy) {
            this.accessPolicy = accessPolicy;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Long getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Long creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Long creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public Destination build() {
            return new Destination(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
