/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.model.ResourcePolicy;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ResourcePolicyMarshaller {
    private static final MarshallingInfo<String> POLICYNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("policyName").isBinary(false).build();
    private static final MarshallingInfo<String> POLICYDOCUMENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("policyDocument").isBinary(false).build();
    private static final MarshallingInfo<Long> LASTUPDATEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastUpdatedTime").isBinary(false).build();
    private static final ResourcePolicyMarshaller INSTANCE = new ResourcePolicyMarshaller();

    private ResourcePolicyMarshaller() {
    }

    public static ResourcePolicyMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ResourcePolicy resourcePolicy, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)resourcePolicy, (String)"resourcePolicy");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)resourcePolicy.policyName(), POLICYNAME_BINDING);
            protocolMarshaller.marshall((Object)resourcePolicy.policyDocument(), POLICYDOCUMENT_BINDING);
            protocolMarshaller.marshall((Object)resourcePolicy.lastUpdatedTime(), LASTUPDATEDTIME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

