/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.model.MetricTransformation;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class MetricTransformationMarshaller {
    private static final MarshallingInfo<String> METRICNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("metricName").isBinary(false).build();
    private static final MarshallingInfo<String> METRICNAMESPACE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("metricNamespace").isBinary(false).build();
    private static final MarshallingInfo<String> METRICVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("metricValue").isBinary(false).build();
    private static final MarshallingInfo<Double> DEFAULTVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("defaultValue").isBinary(false).build();
    private static final MetricTransformationMarshaller INSTANCE = new MetricTransformationMarshaller();

    private MetricTransformationMarshaller() {
    }

    public static MetricTransformationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(MetricTransformation metricTransformation, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)metricTransformation, (String)"metricTransformation");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)metricTransformation.metricName(), METRICNAME_BINDING);
            protocolMarshaller.marshall((Object)metricTransformation.metricNamespace(), METRICNAMESPACE_BINDING);
            protocolMarshaller.marshall((Object)metricTransformation.metricValue(), METRICVALUE_BINDING);
            protocolMarshaller.marshall((Object)metricTransformation.defaultValue(), DEFAULTVALUE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

