/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.model.FilterLogEventsRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class FilterLogEventsRequestModelMarshaller {
    private static final MarshallingInfo<String> LOGGROUPNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("logGroupName").isBinary(false).build();
    private static final MarshallingInfo<List> LOGSTREAMNAMES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("logStreamNames").isBinary(false).build();
    private static final MarshallingInfo<String> LOGSTREAMNAMEPREFIX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("logStreamNamePrefix").isBinary(false).build();
    private static final MarshallingInfo<Long> STARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("startTime").isBinary(false).build();
    private static final MarshallingInfo<Long> ENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("endTime").isBinary(false).build();
    private static final MarshallingInfo<String> FILTERPATTERN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("filterPattern").isBinary(false).build();
    private static final MarshallingInfo<String> NEXTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("nextToken").isBinary(false).build();
    private static final MarshallingInfo<Integer> LIMIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("limit").isBinary(false).build();
    private static final MarshallingInfo<Boolean> INTERLEAVED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("interleaved").isBinary(false).build();
    private static final FilterLogEventsRequestModelMarshaller INSTANCE = new FilterLogEventsRequestModelMarshaller();

    private FilterLogEventsRequestModelMarshaller() {
    }

    public static FilterLogEventsRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(FilterLogEventsRequest filterLogEventsRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)filterLogEventsRequest), (String)"filterLogEventsRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)filterLogEventsRequest.logGroupName(), LOGGROUPNAME_BINDING);
            protocolMarshaller.marshall(filterLogEventsRequest.logStreamNames(), LOGSTREAMNAMES_BINDING);
            protocolMarshaller.marshall((Object)filterLogEventsRequest.logStreamNamePrefix(), LOGSTREAMNAMEPREFIX_BINDING);
            protocolMarshaller.marshall((Object)filterLogEventsRequest.startTime(), STARTTIME_BINDING);
            protocolMarshaller.marshall((Object)filterLogEventsRequest.endTime(), ENDTIME_BINDING);
            protocolMarshaller.marshall((Object)filterLogEventsRequest.filterPattern(), FILTERPATTERN_BINDING);
            protocolMarshaller.marshall((Object)filterLogEventsRequest.nextToken(), NEXTTOKEN_BINDING);
            protocolMarshaller.marshall((Object)filterLogEventsRequest.limit(), LIMIT_BINDING);
            protocolMarshaller.marshall((Object)filterLogEventsRequest.interleaved(), INTERLEAVED_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

