/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.model.ExportTaskExecutionInfo;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ExportTaskExecutionInfoMarshaller {
    private static final MarshallingInfo<Long> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("creationTime").isBinary(false).build();
    private static final MarshallingInfo<Long> COMPLETIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("completionTime").isBinary(false).build();
    private static final ExportTaskExecutionInfoMarshaller INSTANCE = new ExportTaskExecutionInfoMarshaller();

    private ExportTaskExecutionInfoMarshaller() {
    }

    public static ExportTaskExecutionInfoMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ExportTaskExecutionInfo exportTaskExecutionInfo, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)exportTaskExecutionInfo, (String)"exportTaskExecutionInfo");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)exportTaskExecutionInfo.creationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)exportTaskExecutionInfo.completionTime(), COMPLETIONTIME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

