/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.model.CreateExportTaskRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateExportTaskRequestModelMarshaller {
    private static final MarshallingInfo<String> TASKNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("taskName").isBinary(false).build();
    private static final MarshallingInfo<String> LOGGROUPNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("logGroupName").isBinary(false).build();
    private static final MarshallingInfo<String> LOGSTREAMNAMEPREFIX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("logStreamNamePrefix").isBinary(false).build();
    private static final MarshallingInfo<Long> FROM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("from").isBinary(false).build();
    private static final MarshallingInfo<Long> TO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("to").isBinary(false).build();
    private static final MarshallingInfo<String> DESTINATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("destination").isBinary(false).build();
    private static final MarshallingInfo<String> DESTINATIONPREFIX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("destinationPrefix").isBinary(false).build();
    private static final CreateExportTaskRequestModelMarshaller INSTANCE = new CreateExportTaskRequestModelMarshaller();

    private CreateExportTaskRequestModelMarshaller() {
    }

    public static CreateExportTaskRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateExportTaskRequest createExportTaskRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createExportTaskRequest), (String)"createExportTaskRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createExportTaskRequest.taskName(), TASKNAME_BINDING);
            protocolMarshaller.marshall((Object)createExportTaskRequest.logGroupName(), LOGGROUPNAME_BINDING);
            protocolMarshaller.marshall((Object)createExportTaskRequest.logStreamNamePrefix(), LOGSTREAMNAMEPREFIX_BINDING);
            protocolMarshaller.marshall((Object)createExportTaskRequest.from(), FROM_BINDING);
            protocolMarshaller.marshall((Object)createExportTaskRequest.to(), TO_BINDING);
            protocolMarshaller.marshall((Object)createExportTaskRequest.destination(), DESTINATION_BINDING);
            protocolMarshaller.marshall((Object)createExportTaskRequest.destinationPrefix(), DESTINATIONPREFIX_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

