/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.TestEventMessagesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TestMetricFilterRequest
extends CloudWatchLogsRequest
implements ToCopyableBuilder<Builder, TestMetricFilterRequest> {
    private final String filterPattern;
    private final List<String> logEventMessages;

    private TestMetricFilterRequest(BuilderImpl builder) {
        super(builder);
        this.filterPattern = builder.filterPattern;
        this.logEventMessages = builder.logEventMessages;
    }

    public String filterPattern() {
        return this.filterPattern;
    }

    public List<String> logEventMessages() {
        return this.logEventMessages;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filterPattern());
        hashCode = 31 * hashCode + Objects.hashCode(this.logEventMessages());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestMetricFilterRequest)) {
            return false;
        }
        TestMetricFilterRequest other = (TestMetricFilterRequest)((Object)obj);
        return Objects.equals(this.filterPattern(), other.filterPattern()) && Objects.equals(this.logEventMessages(), other.logEventMessages());
    }

    public String toString() {
        return ToString.builder((String)"TestMetricFilterRequest").add("FilterPattern", (Object)this.filterPattern()).add("LogEventMessages", this.logEventMessages()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "filterPattern": {
                return Optional.ofNullable(clazz.cast(this.filterPattern()));
            }
            case "logEventMessages": {
                return Optional.ofNullable(clazz.cast(this.logEventMessages()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudWatchLogsRequest.BuilderImpl
    implements Builder {
        private String filterPattern;
        private List<String> logEventMessages = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TestMetricFilterRequest model) {
            super(model);
            this.filterPattern(model.filterPattern);
            this.logEventMessages(model.logEventMessages);
        }

        public final String getFilterPattern() {
            return this.filterPattern;
        }

        @Override
        public final Builder filterPattern(String filterPattern) {
            this.filterPattern = filterPattern;
            return this;
        }

        public final void setFilterPattern(String filterPattern) {
            this.filterPattern = filterPattern;
        }

        public final Collection<String> getLogEventMessages() {
            return this.logEventMessages;
        }

        @Override
        public final Builder logEventMessages(Collection<String> logEventMessages) {
            this.logEventMessages = TestEventMessagesCopier.copy(logEventMessages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logEventMessages(String ... logEventMessages) {
            this.logEventMessages(Arrays.asList(logEventMessages));
            return this;
        }

        public final void setLogEventMessages(Collection<String> logEventMessages) {
            this.logEventMessages = TestEventMessagesCopier.copy(logEventMessages);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TestMetricFilterRequest build() {
            return new TestMetricFilterRequest(this);
        }
    }

    public static interface Builder
    extends CloudWatchLogsRequest.Builder,
    CopyableBuilder<Builder, TestMetricFilterRequest> {
        public Builder filterPattern(String var1);

        public Builder logEventMessages(Collection<String> var1);

        public Builder logEventMessages(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

