/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cloudwatchlogs.transform.RejectedLogEventsInfoMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RejectedLogEventsInfo
implements StructuredPojo,
ToCopyableBuilder<Builder, RejectedLogEventsInfo> {
    private final Integer tooNewLogEventStartIndex;
    private final Integer tooOldLogEventEndIndex;
    private final Integer expiredLogEventEndIndex;

    private RejectedLogEventsInfo(BuilderImpl builder) {
        this.tooNewLogEventStartIndex = builder.tooNewLogEventStartIndex;
        this.tooOldLogEventEndIndex = builder.tooOldLogEventEndIndex;
        this.expiredLogEventEndIndex = builder.expiredLogEventEndIndex;
    }

    public Integer tooNewLogEventStartIndex() {
        return this.tooNewLogEventStartIndex;
    }

    public Integer tooOldLogEventEndIndex() {
        return this.tooOldLogEventEndIndex;
    }

    public Integer expiredLogEventEndIndex() {
        return this.expiredLogEventEndIndex;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tooNewLogEventStartIndex());
        hashCode = 31 * hashCode + Objects.hashCode(this.tooOldLogEventEndIndex());
        hashCode = 31 * hashCode + Objects.hashCode(this.expiredLogEventEndIndex());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RejectedLogEventsInfo)) {
            return false;
        }
        RejectedLogEventsInfo other = (RejectedLogEventsInfo)obj;
        return Objects.equals(this.tooNewLogEventStartIndex(), other.tooNewLogEventStartIndex()) && Objects.equals(this.tooOldLogEventEndIndex(), other.tooOldLogEventEndIndex()) && Objects.equals(this.expiredLogEventEndIndex(), other.expiredLogEventEndIndex());
    }

    public String toString() {
        return ToString.builder((String)"RejectedLogEventsInfo").add("TooNewLogEventStartIndex", (Object)this.tooNewLogEventStartIndex()).add("TooOldLogEventEndIndex", (Object)this.tooOldLogEventEndIndex()).add("ExpiredLogEventEndIndex", (Object)this.expiredLogEventEndIndex()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "tooNewLogEventStartIndex": {
                return Optional.ofNullable(clazz.cast(this.tooNewLogEventStartIndex()));
            }
            case "tooOldLogEventEndIndex": {
                return Optional.ofNullable(clazz.cast(this.tooOldLogEventEndIndex()));
            }
            case "expiredLogEventEndIndex": {
                return Optional.ofNullable(clazz.cast(this.expiredLogEventEndIndex()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RejectedLogEventsInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer tooNewLogEventStartIndex;
        private Integer tooOldLogEventEndIndex;
        private Integer expiredLogEventEndIndex;

        private BuilderImpl() {
        }

        private BuilderImpl(RejectedLogEventsInfo model) {
            this.tooNewLogEventStartIndex(model.tooNewLogEventStartIndex);
            this.tooOldLogEventEndIndex(model.tooOldLogEventEndIndex);
            this.expiredLogEventEndIndex(model.expiredLogEventEndIndex);
        }

        public final Integer getTooNewLogEventStartIndex() {
            return this.tooNewLogEventStartIndex;
        }

        @Override
        public final Builder tooNewLogEventStartIndex(Integer tooNewLogEventStartIndex) {
            this.tooNewLogEventStartIndex = tooNewLogEventStartIndex;
            return this;
        }

        public final void setTooNewLogEventStartIndex(Integer tooNewLogEventStartIndex) {
            this.tooNewLogEventStartIndex = tooNewLogEventStartIndex;
        }

        public final Integer getTooOldLogEventEndIndex() {
            return this.tooOldLogEventEndIndex;
        }

        @Override
        public final Builder tooOldLogEventEndIndex(Integer tooOldLogEventEndIndex) {
            this.tooOldLogEventEndIndex = tooOldLogEventEndIndex;
            return this;
        }

        public final void setTooOldLogEventEndIndex(Integer tooOldLogEventEndIndex) {
            this.tooOldLogEventEndIndex = tooOldLogEventEndIndex;
        }

        public final Integer getExpiredLogEventEndIndex() {
            return this.expiredLogEventEndIndex;
        }

        @Override
        public final Builder expiredLogEventEndIndex(Integer expiredLogEventEndIndex) {
            this.expiredLogEventEndIndex = expiredLogEventEndIndex;
            return this;
        }

        public final void setExpiredLogEventEndIndex(Integer expiredLogEventEndIndex) {
            this.expiredLogEventEndIndex = expiredLogEventEndIndex;
        }

        public RejectedLogEventsInfo build() {
            return new RejectedLogEventsInfo(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RejectedLogEventsInfo> {
        public Builder tooNewLogEventStartIndex(Integer var1);

        public Builder tooOldLogEventEndIndex(Integer var1);

        public Builder expiredLogEventEndIndex(Integer var1);
    }
}

