/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutRetentionPolicyRequest
extends CloudWatchLogsRequest
implements ToCopyableBuilder<Builder, PutRetentionPolicyRequest> {
    private final String logGroupName;
    private final Integer retentionInDays;

    private PutRetentionPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.logGroupName = builder.logGroupName;
        this.retentionInDays = builder.retentionInDays;
    }

    public String logGroupName() {
        return this.logGroupName;
    }

    public Integer retentionInDays() {
        return this.retentionInDays;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.retentionInDays());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRetentionPolicyRequest)) {
            return false;
        }
        PutRetentionPolicyRequest other = (PutRetentionPolicyRequest)((Object)obj);
        return Objects.equals(this.logGroupName(), other.logGroupName()) && Objects.equals(this.retentionInDays(), other.retentionInDays());
    }

    public String toString() {
        return ToString.builder((String)"PutRetentionPolicyRequest").add("LogGroupName", (Object)this.logGroupName()).add("RetentionInDays", (Object)this.retentionInDays()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "logGroupName": {
                return Optional.ofNullable(clazz.cast(this.logGroupName()));
            }
            case "retentionInDays": {
                return Optional.ofNullable(clazz.cast(this.retentionInDays()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudWatchLogsRequest.BuilderImpl
    implements Builder {
        private String logGroupName;
        private Integer retentionInDays;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRetentionPolicyRequest model) {
            super(model);
            this.logGroupName(model.logGroupName);
            this.retentionInDays(model.retentionInDays);
        }

        public final String getLogGroupName() {
            return this.logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        public final Integer getRetentionInDays() {
            return this.retentionInDays;
        }

        @Override
        public final Builder retentionInDays(Integer retentionInDays) {
            this.retentionInDays = retentionInDays;
            return this;
        }

        public final void setRetentionInDays(Integer retentionInDays) {
            this.retentionInDays = retentionInDays;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutRetentionPolicyRequest build() {
            return new PutRetentionPolicyRequest(this);
        }
    }

    public static interface Builder
    extends CloudWatchLogsRequest.Builder,
    CopyableBuilder<Builder, PutRetentionPolicyRequest> {
        public Builder logGroupName(String var1);

        public Builder retentionInDays(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

