/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cloudwatchlogs.transform.OutputLogEventMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OutputLogEvent
implements StructuredPojo,
ToCopyableBuilder<Builder, OutputLogEvent> {
    private final Long timestamp;
    private final String message;
    private final Long ingestionTime;

    private OutputLogEvent(BuilderImpl builder) {
        this.timestamp = builder.timestamp;
        this.message = builder.message;
        this.ingestionTime = builder.ingestionTime;
    }

    public Long timestamp() {
        return this.timestamp;
    }

    public String message() {
        return this.message;
    }

    public Long ingestionTime() {
        return this.ingestionTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingestionTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputLogEvent)) {
            return false;
        }
        OutputLogEvent other = (OutputLogEvent)obj;
        return Objects.equals(this.timestamp(), other.timestamp()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.ingestionTime(), other.ingestionTime());
    }

    public String toString() {
        return ToString.builder((String)"OutputLogEvent").add("Timestamp", (Object)this.timestamp()).add("Message", (Object)this.message()).add("IngestionTime", (Object)this.ingestionTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
            case "message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "ingestionTime": {
                return Optional.ofNullable(clazz.cast(this.ingestionTime()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OutputLogEventMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Long timestamp;
        private String message;
        private Long ingestionTime;

        private BuilderImpl() {
        }

        private BuilderImpl(OutputLogEvent model) {
            this.timestamp(model.timestamp);
            this.message(model.message);
            this.ingestionTime(model.ingestionTime);
        }

        public final Long getTimestamp() {
            return this.timestamp;
        }

        @Override
        public final Builder timestamp(Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Long timestamp) {
            this.timestamp = timestamp;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final Long getIngestionTime() {
            return this.ingestionTime;
        }

        @Override
        public final Builder ingestionTime(Long ingestionTime) {
            this.ingestionTime = ingestionTime;
            return this;
        }

        public final void setIngestionTime(Long ingestionTime) {
            this.ingestionTime = ingestionTime;
        }

        public OutputLogEvent build() {
            return new OutputLogEvent(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, OutputLogEvent> {
        public Builder timestamp(Long var1);

        public Builder message(String var1);

        public Builder ingestionTime(Long var1);
    }
}

