/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cloudwatchlogs.transform.MetricTransformationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MetricTransformation
implements StructuredPojo,
ToCopyableBuilder<Builder, MetricTransformation> {
    private final String metricName;
    private final String metricNamespace;
    private final String metricValue;
    private final Double defaultValue;

    private MetricTransformation(BuilderImpl builder) {
        this.metricName = builder.metricName;
        this.metricNamespace = builder.metricNamespace;
        this.metricValue = builder.metricValue;
        this.defaultValue = builder.defaultValue;
    }

    public String metricName() {
        return this.metricName;
    }

    public String metricNamespace() {
        return this.metricNamespace;
    }

    public String metricValue() {
        return this.metricValue;
    }

    public Double defaultValue() {
        return this.defaultValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.metricName());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricNamespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultValue());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricTransformation)) {
            return false;
        }
        MetricTransformation other = (MetricTransformation)obj;
        return Objects.equals(this.metricName(), other.metricName()) && Objects.equals(this.metricNamespace(), other.metricNamespace()) && Objects.equals(this.metricValue(), other.metricValue()) && Objects.equals(this.defaultValue(), other.defaultValue());
    }

    public String toString() {
        return ToString.builder((String)"MetricTransformation").add("MetricName", (Object)this.metricName()).add("MetricNamespace", (Object)this.metricNamespace()).add("MetricValue", (Object)this.metricValue()).add("DefaultValue", (Object)this.defaultValue()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "metricName": {
                return Optional.ofNullable(clazz.cast(this.metricName()));
            }
            case "metricNamespace": {
                return Optional.ofNullable(clazz.cast(this.metricNamespace()));
            }
            case "metricValue": {
                return Optional.ofNullable(clazz.cast(this.metricValue()));
            }
            case "defaultValue": {
                return Optional.ofNullable(clazz.cast(this.defaultValue()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MetricTransformationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String metricName;
        private String metricNamespace;
        private String metricValue;
        private Double defaultValue;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricTransformation model) {
            this.metricName(model.metricName);
            this.metricNamespace(model.metricNamespace);
            this.metricValue(model.metricValue);
            this.defaultValue(model.defaultValue);
        }

        public final String getMetricName() {
            return this.metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public final String getMetricNamespace() {
            return this.metricNamespace;
        }

        @Override
        public final Builder metricNamespace(String metricNamespace) {
            this.metricNamespace = metricNamespace;
            return this;
        }

        public final void setMetricNamespace(String metricNamespace) {
            this.metricNamespace = metricNamespace;
        }

        public final String getMetricValue() {
            return this.metricValue;
        }

        @Override
        public final Builder metricValue(String metricValue) {
            this.metricValue = metricValue;
            return this;
        }

        public final void setMetricValue(String metricValue) {
            this.metricValue = metricValue;
        }

        public final Double getDefaultValue() {
            return this.defaultValue;
        }

        @Override
        public final Builder defaultValue(Double defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final void setDefaultValue(Double defaultValue) {
            this.defaultValue = defaultValue;
        }

        public MetricTransformation build() {
            return new MetricTransformation(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, MetricTransformation> {
        public Builder metricName(String var1);

        public Builder metricNamespace(String var1);

        public Builder metricValue(String var1);

        public Builder defaultValue(Double var1);
    }
}

