/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cloudwatchlogs.transform.LogGroupMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LogGroup
implements StructuredPojo,
ToCopyableBuilder<Builder, LogGroup> {
    private final String logGroupName;
    private final Long creationTime;
    private final Integer retentionInDays;
    private final Integer metricFilterCount;
    private final String arn;
    private final Long storedBytes;
    private final String kmsKeyId;

    private LogGroup(BuilderImpl builder) {
        this.logGroupName = builder.logGroupName;
        this.creationTime = builder.creationTime;
        this.retentionInDays = builder.retentionInDays;
        this.metricFilterCount = builder.metricFilterCount;
        this.arn = builder.arn;
        this.storedBytes = builder.storedBytes;
        this.kmsKeyId = builder.kmsKeyId;
    }

    public String logGroupName() {
        return this.logGroupName;
    }

    public Long creationTime() {
        return this.creationTime;
    }

    public Integer retentionInDays() {
        return this.retentionInDays;
    }

    public Integer metricFilterCount() {
        return this.metricFilterCount;
    }

    public String arn() {
        return this.arn;
    }

    public Long storedBytes() {
        return this.storedBytes;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.retentionInDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricFilterCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.storedBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogGroup)) {
            return false;
        }
        LogGroup other = (LogGroup)obj;
        return Objects.equals(this.logGroupName(), other.logGroupName()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.retentionInDays(), other.retentionInDays()) && Objects.equals(this.metricFilterCount(), other.metricFilterCount()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.storedBytes(), other.storedBytes()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId());
    }

    public String toString() {
        return ToString.builder((String)"LogGroup").add("LogGroupName", (Object)this.logGroupName()).add("CreationTime", (Object)this.creationTime()).add("RetentionInDays", (Object)this.retentionInDays()).add("MetricFilterCount", (Object)this.metricFilterCount()).add("Arn", (Object)this.arn()).add("StoredBytes", (Object)this.storedBytes()).add("KmsKeyId", (Object)this.kmsKeyId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "logGroupName": {
                return Optional.ofNullable(clazz.cast(this.logGroupName()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "retentionInDays": {
                return Optional.ofNullable(clazz.cast(this.retentionInDays()));
            }
            case "metricFilterCount": {
                return Optional.ofNullable(clazz.cast(this.metricFilterCount()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "storedBytes": {
                return Optional.ofNullable(clazz.cast(this.storedBytes()));
            }
            case "kmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LogGroupMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String logGroupName;
        private Long creationTime;
        private Integer retentionInDays;
        private Integer metricFilterCount;
        private String arn;
        private Long storedBytes;
        private String kmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(LogGroup model) {
            this.logGroupName(model.logGroupName);
            this.creationTime(model.creationTime);
            this.retentionInDays(model.retentionInDays);
            this.metricFilterCount(model.metricFilterCount);
            this.arn(model.arn);
            this.storedBytes(model.storedBytes);
            this.kmsKeyId(model.kmsKeyId);
        }

        public final String getLogGroupName() {
            return this.logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        public final Long getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Long creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Long creationTime) {
            this.creationTime = creationTime;
        }

        public final Integer getRetentionInDays() {
            return this.retentionInDays;
        }

        @Override
        public final Builder retentionInDays(Integer retentionInDays) {
            this.retentionInDays = retentionInDays;
            return this;
        }

        public final void setRetentionInDays(Integer retentionInDays) {
            this.retentionInDays = retentionInDays;
        }

        public final Integer getMetricFilterCount() {
            return this.metricFilterCount;
        }

        @Override
        public final Builder metricFilterCount(Integer metricFilterCount) {
            this.metricFilterCount = metricFilterCount;
            return this;
        }

        public final void setMetricFilterCount(Integer metricFilterCount) {
            this.metricFilterCount = metricFilterCount;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Long getStoredBytes() {
            return this.storedBytes;
        }

        @Override
        public final Builder storedBytes(Long storedBytes) {
            this.storedBytes = storedBytes;
            return this;
        }

        public final void setStoredBytes(Long storedBytes) {
            this.storedBytes = storedBytes;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public LogGroup build() {
            return new LogGroup(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LogGroup> {
        public Builder logGroupName(String var1);

        public Builder creationTime(Long var1);

        public Builder retentionInDays(Integer var1);

        public Builder metricFilterCount(Integer var1);

        public Builder arn(String var1);

        public Builder storedBytes(Long var1);

        public Builder kmsKeyId(String var1);
    }
}

