/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTagsLogGroupResponse
extends CloudWatchLogsResponse
implements ToCopyableBuilder<Builder, ListTagsLogGroupResponse> {
    private final Map<String, String> tags;

    private ListTagsLogGroupResponse(BuilderImpl builder) {
        super(builder);
        this.tags = builder.tags;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTagsLogGroupResponse)) {
            return false;
        }
        ListTagsLogGroupResponse other = (ListTagsLogGroupResponse)((Object)obj);
        return Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"ListTagsLogGroupResponse").add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudWatchLogsResponse.BuilderImpl
    implements Builder {
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListTagsLogGroupResponse model) {
            super(model);
            this.tags(model.tags);
        }

        public final Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public ListTagsLogGroupResponse build() {
            return new ListTagsLogGroupResponse(this);
        }
    }

    public static interface Builder
    extends CloudWatchLogsResponse.Builder,
    CopyableBuilder<Builder, ListTagsLogGroupResponse> {
        public Builder tags(Map<String, String> var1);
    }
}

