/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchevents.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudwatchevents.model.CloudWatchEventsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteRuleRequest
extends CloudWatchEventsRequest
implements ToCopyableBuilder<Builder, DeleteRuleRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeleteRuleRequest.getter(DeleteRuleRequest::name)).setter(DeleteRuleRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> EVENT_BUS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeleteRuleRequest.getter(DeleteRuleRequest::eventBusName)).setter(DeleteRuleRequest.setter(Builder::eventBusName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventBusName").build()}).build();
    private static final SdkField<Boolean> FORCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(DeleteRuleRequest.getter(DeleteRuleRequest::force)).setter(DeleteRuleRequest.setter(Builder::force)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Force").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, EVENT_BUS_NAME_FIELD, FORCE_FIELD));
    private final String name;
    private final String eventBusName;
    private final Boolean force;

    private DeleteRuleRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.eventBusName = builder.eventBusName;
        this.force = builder.force;
    }

    public String name() {
        return this.name;
    }

    public String eventBusName() {
        return this.eventBusName;
    }

    public Boolean force() {
        return this.force;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventBusName());
        hashCode = 31 * hashCode + Objects.hashCode(this.force());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteRuleRequest)) {
            return false;
        }
        DeleteRuleRequest other = (DeleteRuleRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.eventBusName(), other.eventBusName()) && Objects.equals(this.force(), other.force());
    }

    public String toString() {
        return ToString.builder((String)"DeleteRuleRequest").add("Name", (Object)this.name()).add("EventBusName", (Object)this.eventBusName()).add("Force", (Object)this.force()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "EventBusName": {
                return Optional.ofNullable(clazz.cast(this.eventBusName()));
            }
            case "Force": {
                return Optional.ofNullable(clazz.cast(this.force()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteRuleRequest, T> g) {
        return obj -> g.apply((DeleteRuleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchEventsRequest.BuilderImpl
    implements Builder {
        private String name;
        private String eventBusName;
        private Boolean force;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteRuleRequest model) {
            super(model);
            this.name(model.name);
            this.eventBusName(model.eventBusName);
            this.force(model.force);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getEventBusName() {
            return this.eventBusName;
        }

        @Override
        public final Builder eventBusName(String eventBusName) {
            this.eventBusName = eventBusName;
            return this;
        }

        public final void setEventBusName(String eventBusName) {
            this.eventBusName = eventBusName;
        }

        public final Boolean getForce() {
            return this.force;
        }

        @Override
        public final Builder force(Boolean force) {
            this.force = force;
            return this;
        }

        public final void setForce(Boolean force) {
            this.force = force;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteRuleRequest build() {
            return new DeleteRuleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudWatchEventsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteRuleRequest> {
        public Builder name(String var1);

        public Builder eventBusName(String var1);

        public Builder force(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

