/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchevents.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudwatchevents.model.ArchiveState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Archive
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Archive> {
    private static final SdkField<String> ARCHIVE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ArchiveName").getter(Archive.getter(Archive::archiveName)).setter(Archive.setter(Builder::archiveName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArchiveName").build()}).build();
    private static final SdkField<String> EVENT_SOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventSourceArn").getter(Archive.getter(Archive::eventSourceArn)).setter(Archive.setter(Builder::eventSourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventSourceArn").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(Archive.getter(Archive::stateAsString)).setter(Archive.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> STATE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StateReason").getter(Archive.getter(Archive::stateReason)).setter(Archive.setter(Builder::stateReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateReason").build()}).build();
    private static final SdkField<Integer> RETENTION_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RetentionDays").getter(Archive.getter(Archive::retentionDays)).setter(Archive.setter(Builder::retentionDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetentionDays").build()}).build();
    private static final SdkField<Long> SIZE_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("SizeBytes").getter(Archive.getter(Archive::sizeBytes)).setter(Archive.setter(Builder::sizeBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizeBytes").build()}).build();
    private static final SdkField<Long> EVENT_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("EventCount").getter(Archive.getter(Archive::eventCount)).setter(Archive.setter(Builder::eventCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventCount").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(Archive.getter(Archive::creationTime)).setter(Archive.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARCHIVE_NAME_FIELD, EVENT_SOURCE_ARN_FIELD, STATE_FIELD, STATE_REASON_FIELD, RETENTION_DAYS_FIELD, SIZE_BYTES_FIELD, EVENT_COUNT_FIELD, CREATION_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ArchiveName", ARCHIVE_NAME_FIELD);
            this.put("EventSourceArn", EVENT_SOURCE_ARN_FIELD);
            this.put("State", STATE_FIELD);
            this.put("StateReason", STATE_REASON_FIELD);
            this.put("RetentionDays", RETENTION_DAYS_FIELD);
            this.put("SizeBytes", SIZE_BYTES_FIELD);
            this.put("EventCount", EVENT_COUNT_FIELD);
            this.put("CreationTime", CREATION_TIME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String archiveName;
    private final String eventSourceArn;
    private final String state;
    private final String stateReason;
    private final Integer retentionDays;
    private final Long sizeBytes;
    private final Long eventCount;
    private final Instant creationTime;

    private Archive(BuilderImpl builder) {
        this.archiveName = builder.archiveName;
        this.eventSourceArn = builder.eventSourceArn;
        this.state = builder.state;
        this.stateReason = builder.stateReason;
        this.retentionDays = builder.retentionDays;
        this.sizeBytes = builder.sizeBytes;
        this.eventCount = builder.eventCount;
        this.creationTime = builder.creationTime;
    }

    public final String archiveName() {
        return this.archiveName;
    }

    public final String eventSourceArn() {
        return this.eventSourceArn;
    }

    public final ArchiveState state() {
        return ArchiveState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String stateReason() {
        return this.stateReason;
    }

    public final Integer retentionDays() {
        return this.retentionDays;
    }

    public final Long sizeBytes() {
        return this.sizeBytes;
    }

    public final Long eventCount() {
        return this.eventCount;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.archiveName());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventSourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.retentionDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.sizeBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Archive)) {
            return false;
        }
        Archive other = (Archive)obj;
        return Objects.equals(this.archiveName(), other.archiveName()) && Objects.equals(this.eventSourceArn(), other.eventSourceArn()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.stateReason(), other.stateReason()) && Objects.equals(this.retentionDays(), other.retentionDays()) && Objects.equals(this.sizeBytes(), other.sizeBytes()) && Objects.equals(this.eventCount(), other.eventCount()) && Objects.equals(this.creationTime(), other.creationTime());
    }

    public final String toString() {
        return ToString.builder((String)"Archive").add("ArchiveName", (Object)this.archiveName()).add("EventSourceArn", (Object)this.eventSourceArn()).add("State", (Object)this.stateAsString()).add("StateReason", (Object)this.stateReason()).add("RetentionDays", (Object)this.retentionDays()).add("SizeBytes", (Object)this.sizeBytes()).add("EventCount", (Object)this.eventCount()).add("CreationTime", (Object)this.creationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ArchiveName": {
                return Optional.ofNullable(clazz.cast(this.archiveName()));
            }
            case "EventSourceArn": {
                return Optional.ofNullable(clazz.cast(this.eventSourceArn()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "StateReason": {
                return Optional.ofNullable(clazz.cast(this.stateReason()));
            }
            case "RetentionDays": {
                return Optional.ofNullable(clazz.cast(this.retentionDays()));
            }
            case "SizeBytes": {
                return Optional.ofNullable(clazz.cast(this.sizeBytes()));
            }
            case "EventCount": {
                return Optional.ofNullable(clazz.cast(this.eventCount()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Archive, T> g) {
        return obj -> g.apply((Archive)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String archiveName;
        private String eventSourceArn;
        private String state;
        private String stateReason;
        private Integer retentionDays;
        private Long sizeBytes;
        private Long eventCount;
        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Archive model) {
            this.archiveName(model.archiveName);
            this.eventSourceArn(model.eventSourceArn);
            this.state(model.state);
            this.stateReason(model.stateReason);
            this.retentionDays(model.retentionDays);
            this.sizeBytes(model.sizeBytes);
            this.eventCount(model.eventCount);
            this.creationTime(model.creationTime);
        }

        public final String getArchiveName() {
            return this.archiveName;
        }

        public final void setArchiveName(String archiveName) {
            this.archiveName = archiveName;
        }

        @Override
        public final Builder archiveName(String archiveName) {
            this.archiveName = archiveName;
            return this;
        }

        public final String getEventSourceArn() {
            return this.eventSourceArn;
        }

        public final void setEventSourceArn(String eventSourceArn) {
            this.eventSourceArn = eventSourceArn;
        }

        @Override
        public final Builder eventSourceArn(String eventSourceArn) {
            this.eventSourceArn = eventSourceArn;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ArchiveState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStateReason() {
            return this.stateReason;
        }

        public final void setStateReason(String stateReason) {
            this.stateReason = stateReason;
        }

        @Override
        public final Builder stateReason(String stateReason) {
            this.stateReason = stateReason;
            return this;
        }

        public final Integer getRetentionDays() {
            return this.retentionDays;
        }

        public final void setRetentionDays(Integer retentionDays) {
            this.retentionDays = retentionDays;
        }

        @Override
        public final Builder retentionDays(Integer retentionDays) {
            this.retentionDays = retentionDays;
            return this;
        }

        public final Long getSizeBytes() {
            return this.sizeBytes;
        }

        public final void setSizeBytes(Long sizeBytes) {
            this.sizeBytes = sizeBytes;
        }

        @Override
        public final Builder sizeBytes(Long sizeBytes) {
            this.sizeBytes = sizeBytes;
            return this;
        }

        public final Long getEventCount() {
            return this.eventCount;
        }

        public final void setEventCount(Long eventCount) {
            this.eventCount = eventCount;
        }

        @Override
        public final Builder eventCount(Long eventCount) {
            this.eventCount = eventCount;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public Archive build() {
            return new Archive(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Archive> {
        public Builder archiveName(String var1);

        public Builder eventSourceArn(String var1);

        public Builder state(String var1);

        public Builder state(ArchiveState var1);

        public Builder stateReason(String var1);

        public Builder retentionDays(Integer var1);

        public Builder sizeBytes(Long var1);

        public Builder eventCount(Long var1);

        public Builder creationTime(Instant var1);
    }
}

