/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchevents.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListApiDestinationsResponse extends CloudWatchEventsResponse implements
        ToCopyableBuilder<ListApiDestinationsResponse.Builder, ListApiDestinationsResponse> {
    private static final SdkField<List<ApiDestination>> API_DESTINATIONS_FIELD = SdkField
            .<List<ApiDestination>> builder(MarshallingType.LIST)
            .memberName("ApiDestinations")
            .getter(getter(ListApiDestinationsResponse::apiDestinations))
            .setter(setter(Builder::apiDestinations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApiDestinations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ApiDestination> builder(MarshallingType.SDK_POJO)
                                            .constructor(ApiDestination::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListApiDestinationsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_DESTINATIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ApiDestination> apiDestinations;

    private final String nextToken;

    private ListApiDestinationsResponse(BuilderImpl builder) {
        super(builder);
        this.apiDestinations = builder.apiDestinations;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ApiDestinations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasApiDestinations() {
        return apiDestinations != null && !(apiDestinations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>ApiDestination</code> objects that include information about an API destination.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasApiDestinations} method.
     * </p>
     * 
     * @return An array of <code>ApiDestination</code> objects that include information about an API destination.
     */
    public final List<ApiDestination> apiDestinations() {
        return apiDestinations;
    }

    /**
     * <p>
     * A token you can use in a subsequent request to retrieve the next set of results.
     * </p>
     * 
     * @return A token you can use in a subsequent request to retrieve the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasApiDestinations() ? apiDestinations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApiDestinationsResponse)) {
            return false;
        }
        ListApiDestinationsResponse other = (ListApiDestinationsResponse) obj;
        return hasApiDestinations() == other.hasApiDestinations() && Objects.equals(apiDestinations(), other.apiDestinations())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListApiDestinationsResponse")
                .add("ApiDestinations", hasApiDestinations() ? apiDestinations() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApiDestinations":
            return Optional.ofNullable(clazz.cast(apiDestinations()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListApiDestinationsResponse, T> g) {
        return obj -> g.apply((ListApiDestinationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchEventsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListApiDestinationsResponse> {
        /**
         * <p>
         * An array of <code>ApiDestination</code> objects that include information about an API destination.
         * </p>
         * 
         * @param apiDestinations
         *        An array of <code>ApiDestination</code> objects that include information about an API destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiDestinations(Collection<ApiDestination> apiDestinations);

        /**
         * <p>
         * An array of <code>ApiDestination</code> objects that include information about an API destination.
         * </p>
         * 
         * @param apiDestinations
         *        An array of <code>ApiDestination</code> objects that include information about an API destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiDestinations(ApiDestination... apiDestinations);

        /**
         * <p>
         * An array of <code>ApiDestination</code> objects that include information about an API destination.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudwatchevents.model.ApiDestination.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.cloudwatchevents.model.ApiDestination#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudwatchevents.model.ApiDestination.Builder#build()} is called
         * immediately and its result is passed to {@link #apiDestinations(List<ApiDestination>)}.
         * 
         * @param apiDestinations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudwatchevents.model.ApiDestination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #apiDestinations(java.util.Collection<ApiDestination>)
         */
        Builder apiDestinations(Consumer<ApiDestination.Builder>... apiDestinations);

        /**
         * <p>
         * A token you can use in a subsequent request to retrieve the next set of results.
         * </p>
         * 
         * @param nextToken
         *        A token you can use in a subsequent request to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CloudWatchEventsResponse.BuilderImpl implements Builder {
        private List<ApiDestination> apiDestinations = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListApiDestinationsResponse model) {
            super(model);
            apiDestinations(model.apiDestinations);
            nextToken(model.nextToken);
        }

        public final List<ApiDestination.Builder> getApiDestinations() {
            List<ApiDestination.Builder> result = ApiDestinationResponseListCopier.copyToBuilder(this.apiDestinations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setApiDestinations(Collection<ApiDestination.BuilderImpl> apiDestinations) {
            this.apiDestinations = ApiDestinationResponseListCopier.copyFromBuilder(apiDestinations);
        }

        @Override
        public final Builder apiDestinations(Collection<ApiDestination> apiDestinations) {
            this.apiDestinations = ApiDestinationResponseListCopier.copy(apiDestinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder apiDestinations(ApiDestination... apiDestinations) {
            apiDestinations(Arrays.asList(apiDestinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder apiDestinations(Consumer<ApiDestination.Builder>... apiDestinations) {
            apiDestinations(Stream.of(apiDestinations).map(c -> ApiDestination.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListApiDestinationsResponse build() {
            return new ListApiDestinationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
