/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchevents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RetryPolicy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RetryPolicy> {
    private static final SdkField<Integer> MAXIMUM_RETRY_ATTEMPTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaximumRetryAttempts").getter(RetryPolicy.getter(RetryPolicy::maximumRetryAttempts)).setter(RetryPolicy.setter(Builder::maximumRetryAttempts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumRetryAttempts").build()}).build();
    private static final SdkField<Integer> MAXIMUM_EVENT_AGE_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaximumEventAgeInSeconds").getter(RetryPolicy.getter(RetryPolicy::maximumEventAgeInSeconds)).setter(RetryPolicy.setter(Builder::maximumEventAgeInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumEventAgeInSeconds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAXIMUM_RETRY_ATTEMPTS_FIELD, MAXIMUM_EVENT_AGE_IN_SECONDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer maximumRetryAttempts;
    private final Integer maximumEventAgeInSeconds;

    private RetryPolicy(BuilderImpl builder) {
        this.maximumRetryAttempts = builder.maximumRetryAttempts;
        this.maximumEventAgeInSeconds = builder.maximumEventAgeInSeconds;
    }

    public Integer maximumRetryAttempts() {
        return this.maximumRetryAttempts;
    }

    public Integer maximumEventAgeInSeconds() {
        return this.maximumEventAgeInSeconds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumRetryAttempts());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumEventAgeInSeconds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetryPolicy)) {
            return false;
        }
        RetryPolicy other = (RetryPolicy)obj;
        return Objects.equals(this.maximumRetryAttempts(), other.maximumRetryAttempts()) && Objects.equals(this.maximumEventAgeInSeconds(), other.maximumEventAgeInSeconds());
    }

    public String toString() {
        return ToString.builder((String)"RetryPolicy").add("MaximumRetryAttempts", (Object)this.maximumRetryAttempts()).add("MaximumEventAgeInSeconds", (Object)this.maximumEventAgeInSeconds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MaximumRetryAttempts": {
                return Optional.ofNullable(clazz.cast(this.maximumRetryAttempts()));
            }
            case "MaximumEventAgeInSeconds": {
                return Optional.ofNullable(clazz.cast(this.maximumEventAgeInSeconds()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RetryPolicy, T> g) {
        return obj -> g.apply((RetryPolicy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer maximumRetryAttempts;
        private Integer maximumEventAgeInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(RetryPolicy model) {
            this.maximumRetryAttempts(model.maximumRetryAttempts);
            this.maximumEventAgeInSeconds(model.maximumEventAgeInSeconds);
        }

        public final Integer getMaximumRetryAttempts() {
            return this.maximumRetryAttempts;
        }

        @Override
        public final Builder maximumRetryAttempts(Integer maximumRetryAttempts) {
            this.maximumRetryAttempts = maximumRetryAttempts;
            return this;
        }

        public final void setMaximumRetryAttempts(Integer maximumRetryAttempts) {
            this.maximumRetryAttempts = maximumRetryAttempts;
        }

        public final Integer getMaximumEventAgeInSeconds() {
            return this.maximumEventAgeInSeconds;
        }

        @Override
        public final Builder maximumEventAgeInSeconds(Integer maximumEventAgeInSeconds) {
            this.maximumEventAgeInSeconds = maximumEventAgeInSeconds;
            return this;
        }

        public final void setMaximumEventAgeInSeconds(Integer maximumEventAgeInSeconds) {
            this.maximumEventAgeInSeconds = maximumEventAgeInSeconds;
        }

        public RetryPolicy build() {
            return new RetryPolicy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RetryPolicy> {
        public Builder maximumRetryAttempts(Integer var1);

        public Builder maximumEventAgeInSeconds(Integer var1);
    }
}

