/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchevents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RedshiftDataParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RedshiftDataParameters> {
    private static final SdkField<String> SECRET_MANAGER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecretManagerArn").getter(RedshiftDataParameters.getter(RedshiftDataParameters::secretManagerArn)).setter(RedshiftDataParameters.setter(Builder::secretManagerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretManagerArn").build()}).build();
    private static final SdkField<String> DATABASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Database").getter(RedshiftDataParameters.getter(RedshiftDataParameters::database)).setter(RedshiftDataParameters.setter(Builder::database)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Database").build()}).build();
    private static final SdkField<String> DB_USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DbUser").getter(RedshiftDataParameters.getter(RedshiftDataParameters::dbUser)).setter(RedshiftDataParameters.setter(Builder::dbUser)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbUser").build()}).build();
    private static final SdkField<String> SQL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Sql").getter(RedshiftDataParameters.getter(RedshiftDataParameters::sql)).setter(RedshiftDataParameters.setter(Builder::sql)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sql").build()}).build();
    private static final SdkField<String> STATEMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatementName").getter(RedshiftDataParameters.getter(RedshiftDataParameters::statementName)).setter(RedshiftDataParameters.setter(Builder::statementName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatementName").build()}).build();
    private static final SdkField<Boolean> WITH_EVENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("WithEvent").getter(RedshiftDataParameters.getter(RedshiftDataParameters::withEvent)).setter(RedshiftDataParameters.setter(Builder::withEvent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WithEvent").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECRET_MANAGER_ARN_FIELD, DATABASE_FIELD, DB_USER_FIELD, SQL_FIELD, STATEMENT_NAME_FIELD, WITH_EVENT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String secretManagerArn;
    private final String database;
    private final String dbUser;
    private final String sql;
    private final String statementName;
    private final Boolean withEvent;

    private RedshiftDataParameters(BuilderImpl builder) {
        this.secretManagerArn = builder.secretManagerArn;
        this.database = builder.database;
        this.dbUser = builder.dbUser;
        this.sql = builder.sql;
        this.statementName = builder.statementName;
        this.withEvent = builder.withEvent;
    }

    public String secretManagerArn() {
        return this.secretManagerArn;
    }

    public String database() {
        return this.database;
    }

    public String dbUser() {
        return this.dbUser;
    }

    public String sql() {
        return this.sql;
    }

    public String statementName() {
        return this.statementName;
    }

    public Boolean withEvent() {
        return this.withEvent;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.secretManagerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.database());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbUser());
        hashCode = 31 * hashCode + Objects.hashCode(this.sql());
        hashCode = 31 * hashCode + Objects.hashCode(this.statementName());
        hashCode = 31 * hashCode + Objects.hashCode(this.withEvent());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftDataParameters)) {
            return false;
        }
        RedshiftDataParameters other = (RedshiftDataParameters)obj;
        return Objects.equals(this.secretManagerArn(), other.secretManagerArn()) && Objects.equals(this.database(), other.database()) && Objects.equals(this.dbUser(), other.dbUser()) && Objects.equals(this.sql(), other.sql()) && Objects.equals(this.statementName(), other.statementName()) && Objects.equals(this.withEvent(), other.withEvent());
    }

    public String toString() {
        return ToString.builder((String)"RedshiftDataParameters").add("SecretManagerArn", (Object)this.secretManagerArn()).add("Database", (Object)this.database()).add("DbUser", (Object)this.dbUser()).add("Sql", (Object)this.sql()).add("StatementName", (Object)this.statementName()).add("WithEvent", (Object)this.withEvent()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SecretManagerArn": {
                return Optional.ofNullable(clazz.cast(this.secretManagerArn()));
            }
            case "Database": {
                return Optional.ofNullable(clazz.cast(this.database()));
            }
            case "DbUser": {
                return Optional.ofNullable(clazz.cast(this.dbUser()));
            }
            case "Sql": {
                return Optional.ofNullable(clazz.cast(this.sql()));
            }
            case "StatementName": {
                return Optional.ofNullable(clazz.cast(this.statementName()));
            }
            case "WithEvent": {
                return Optional.ofNullable(clazz.cast(this.withEvent()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RedshiftDataParameters, T> g) {
        return obj -> g.apply((RedshiftDataParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String secretManagerArn;
        private String database;
        private String dbUser;
        private String sql;
        private String statementName;
        private Boolean withEvent;

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftDataParameters model) {
            this.secretManagerArn(model.secretManagerArn);
            this.database(model.database);
            this.dbUser(model.dbUser);
            this.sql(model.sql);
            this.statementName(model.statementName);
            this.withEvent(model.withEvent);
        }

        public final String getSecretManagerArn() {
            return this.secretManagerArn;
        }

        @Override
        public final Builder secretManagerArn(String secretManagerArn) {
            this.secretManagerArn = secretManagerArn;
            return this;
        }

        public final void setSecretManagerArn(String secretManagerArn) {
            this.secretManagerArn = secretManagerArn;
        }

        public final String getDatabase() {
            return this.database;
        }

        @Override
        public final Builder database(String database) {
            this.database = database;
            return this;
        }

        public final void setDatabase(String database) {
            this.database = database;
        }

        public final String getDbUser() {
            return this.dbUser;
        }

        @Override
        public final Builder dbUser(String dbUser) {
            this.dbUser = dbUser;
            return this;
        }

        public final void setDbUser(String dbUser) {
            this.dbUser = dbUser;
        }

        public final String getSql() {
            return this.sql;
        }

        @Override
        public final Builder sql(String sql) {
            this.sql = sql;
            return this;
        }

        public final void setSql(String sql) {
            this.sql = sql;
        }

        public final String getStatementName() {
            return this.statementName;
        }

        @Override
        public final Builder statementName(String statementName) {
            this.statementName = statementName;
            return this;
        }

        public final void setStatementName(String statementName) {
            this.statementName = statementName;
        }

        public final Boolean getWithEvent() {
            return this.withEvent;
        }

        @Override
        public final Builder withEvent(Boolean withEvent) {
            this.withEvent = withEvent;
            return this;
        }

        public final void setWithEvent(Boolean withEvent) {
            this.withEvent = withEvent;
        }

        public RedshiftDataParameters build() {
            return new RedshiftDataParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RedshiftDataParameters> {
        public Builder secretManagerArn(String var1);

        public Builder database(String var1);

        public Builder dbUser(String var1);

        public Builder sql(String var1);

        public Builder statementName(String var1);

        public Builder withEvent(Boolean var1);
    }
}

