/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchevents.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cloudwatchevents.model.NetworkConfiguration;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class NetworkConfigurationMarshaller {
    private static final MarshallingInfo<StructuredPojo> AWSVPCCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("awsvpcConfiguration").isBinary(false).build();
    private static final NetworkConfigurationMarshaller INSTANCE = new NetworkConfigurationMarshaller();

    private NetworkConfigurationMarshaller() {
    }

    public static NetworkConfigurationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(NetworkConfiguration networkConfiguration, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)networkConfiguration, (String)"networkConfiguration");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)networkConfiguration.awsvpcConfiguration(), AWSVPCCONFIGURATION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

