/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchevents.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudwatchevents.model.KinesisParameters;

public class KinesisParametersUnmarshaller
implements Unmarshaller<KinesisParameters, JsonUnmarshallerContext> {
    private static final KinesisParametersUnmarshaller INSTANCE = new KinesisParametersUnmarshaller();

    public KinesisParameters unmarshall(JsonUnmarshallerContext context) throws Exception {
        KinesisParameters.Builder kinesisParametersBuilder = KinesisParameters.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("PartitionKeyPath", targetDepth)) {
                    context.nextToken();
                    kinesisParametersBuilder.partitionKeyPath((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (KinesisParameters)kinesisParametersBuilder.build();
    }

    public static KinesisParametersUnmarshaller getInstance() {
        return INSTANCE;
    }
}

