/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchevents.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.model.BatchRetryStrategy;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class BatchRetryStrategyMarshaller {
    private static final MarshallingInfo<Integer> ATTEMPTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Attempts").isBinary(false).build();
    private static final BatchRetryStrategyMarshaller INSTANCE = new BatchRetryStrategyMarshaller();

    private BatchRetryStrategyMarshaller() {
    }

    public static BatchRetryStrategyMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(BatchRetryStrategy batchRetryStrategy, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)batchRetryStrategy, (String)"batchRetryStrategy");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)batchRetryStrategy.attempts(), ATTEMPTS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

